/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.util;

import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.ParticleEnum;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.internal.HandyRunnable;
import cn.handyplus.intensify.lib.internal.HandySchedulerUtil;
import cn.handyplus.intensify.lib.util.LegacyUtil;
import cn.handyplus.intensify.param.PlayerParticle;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class ParticleEffectUtil {
    public static void particleEffect(final Player player) {
        boolean particleEffect = BaseConstants.CONFIG.getBoolean("particleEffect", true);
        if (!particleEffect) {
            return;
        }
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                } else if (!player.isDead() && IntensifyConstants.PLAYER_PARTICLE_MAP.get(player.getName()) != null && IntensifyConstants.PLAYER_PARTICLE_MAP.get(player.getName()).getIsOpen().booleanValue()) {
                    PlayerParticle playerParticle = IntensifyConstants.PLAYER_PARTICLE_MAP.get(player.getName());
                    ParticleEnum particleEnum = ParticleEnum.getEnum(playerParticle.getColor());
                    ParticleEffectUtil.circle(player, particleEnum);
                }
            }
        };
        HandySchedulerUtil.runTaskTimer(handyRunnable, 0L, 20L);
    }

    private static void circle(Player player, ParticleEnum particleEnum) {
        if (particleEnum == null) {
            return;
        }
        double angle = 0.0;
        Particle.DustOptions dustOptions = new Particle.DustOptions(particleEnum.getColor(), 1.0f);
        Location location = player.getLocation();
        for (int i = 0; i < 25; ++i) {
            double x = 0.75 * Math.sin(angle);
            double z = 0.75 * Math.cos(angle);
            angle += 0.251;
            player.getWorld().spawnParticle(LegacyUtil.getRedStone(), location.getX() + x, location.getY(), location.getZ() + z, 0, 0.0, 1.0, 0.0, (Object)dustOptions);
        }
    }
}

