/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.util;

import cn.handyplus.intensify.PlayerIntensify;
import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.entity.PlayerIntensifyEntity;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.hologram.HdUtil;
import cn.handyplus.intensify.lib.internal.HandyRunnable;
import cn.handyplus.intensify.lib.internal.HandySchedulerUtil;
import cn.handyplus.intensify.service.PlayerIntensifyService;
import cn.handyplus.intensify.util.ConfigUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ScheduledTask {
    public static void init() {
        ScheduledTask.clearLocationTask();
        ScheduledTask.refreshHdTask();
    }

    public static void clearLocationTask() {
        HandySchedulerUtil.runTaskTimerAsynchronously(() -> {
            boolean isChunkLimit = BaseConstants.CONFIG.getBoolean("isChunkLimit", true);
            if (!isChunkLimit) {
                return;
            }
            IntensifyConstants.CHUNK_SET.clear();
        }, 20L, (long)BaseConstants.CONFIG.getInt("chunkLimitTime", 1800) * 20L);
    }

    public static void refreshHdTask() {
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                if (!PlayerIntensify.USE_HD) {
                    this.cancel();
                    return;
                }
                HandySchedulerUtil.runTask(HdUtil::deleteAll);
                List<PlayerIntensifyEntity> ranking = PlayerIntensifyService.getInstance().findRanking();
                if (CollUtil.isEmpty(ranking)) {
                    return;
                }
                boolean rst = ConfigUtil.HOLOGRAM_CONFIG.getBoolean("hdLocation.enable");
                if (!rst) {
                    return;
                }
                Location location = null;
                String world = ConfigUtil.HOLOGRAM_CONFIG.getString("hdLocation.world");
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (!onlinePlayer.getWorld().getName().equals(world)) continue;
                    Location playerLocation = onlinePlayer.getLocation();
                    playerLocation.setX(ConfigUtil.HOLOGRAM_CONFIG.getDouble("hdLocation.x"));
                    playerLocation.setY(ConfigUtil.HOLOGRAM_CONFIG.getDouble("hdLocation.y"));
                    playerLocation.setZ(ConfigUtil.HOLOGRAM_CONFIG.getDouble("hdLocation.z"));
                    location = playerLocation;
                    break;
                }
                if (location == null) {
                    return;
                }
                Location finalLocation = location;
                HandySchedulerUtil.runTask(() -> HdUtil.create(IntensifyUtil.getTextLineList(ranking), finalLocation, ((PlayerIntensifyEntity)ranking.get(0)).getMaterialName(), 0));
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 20L, 20L * (long)ConfigUtil.HOLOGRAM_CONFIG.getInt("hdLocation.refresh"));
    }
}

