/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.api;

import cn.handyplus.intensify.constants.CokesTypeEnum;
import cn.handyplus.intensify.constants.IntensifyCardEnum;
import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.entity.PlayerIntensifyEntity;
import cn.handyplus.intensify.lib.core.MapUtil;
import cn.handyplus.intensify.lib.core.NumberUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.service.PlayerIntensifyService;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class IntensifyApi {
    private IntensifyApi() {
    }

    public static IntensifyApi getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(String pluginName, UUID playerUuid, int num) {
        Map<String, Integer> playerMap = IntensifyConstants.PLAYER_PROBABILITY_MAP.get(playerUuid);
        if (playerMap == null) {
            playerMap = MapUtil.newHashMapWithExpectedSize(1);
            playerMap.put(pluginName, num);
            IntensifyConstants.PLAYER_PROBABILITY_MAP.put(playerUuid, playerMap);
        } else {
            playerMap.merge(pluginName, num, Integer::sum);
            IntensifyConstants.PLAYER_PROBABILITY_MAP.put(playerUuid, playerMap);
        }
        return true;
    }

    public boolean sub(String pluginName, UUID playerUuid, int num) {
        Map<String, Integer> playerMap = IntensifyConstants.PLAYER_PROBABILITY_MAP.get(playerUuid);
        if (playerMap == null) {
            playerMap = MapUtil.newHashMapWithExpectedSize(1);
            playerMap.put(pluginName, num);
            IntensifyConstants.PLAYER_PROBABILITY_MAP.put(playerUuid, playerMap);
        } else {
            Integer oldNum = playerMap.get(pluginName);
            if (oldNum == null) {
                playerMap.put(pluginName, -num);
            } else {
                playerMap.put(pluginName, oldNum - num);
            }
            IntensifyConstants.PLAYER_PROBABILITY_MAP.put(playerUuid, playerMap);
        }
        return true;
    }

    public boolean clear(String pluginName, UUID playerUuid) {
        Map<String, Integer> playerMap = IntensifyConstants.PLAYER_PROBABILITY_MAP.get(playerUuid);
        if (playerMap == null) {
            return true;
        }
        Integer num = playerMap.get(pluginName);
        if (num != null) {
            playerMap.remove(pluginName);
        }
        return true;
    }

    public int get(String pluginName, UUID playerUuid) {
        Map<String, Integer> playerMap = IntensifyConstants.PLAYER_PROBABILITY_MAP.get(playerUuid);
        if (playerMap == null) {
            return 0;
        }
        Integer num = playerMap.get(pluginName);
        if (num != null) {
            return num;
        }
        return 0;
    }

    public int get(UUID playerUuid) {
        int sum = 0;
        if (playerUuid == null) {
            return sum;
        }
        Map<String, Integer> playerMap = IntensifyConstants.PLAYER_PROBABILITY_MAP.get(playerUuid);
        if (playerMap == null) {
            return sum;
        }
        for (String pluginName : playerMap.keySet()) {
            Integer num = playerMap.get(pluginName);
            if (num == null) continue;
            sum += num.intValue();
        }
        return sum;
    }

    public PlayerIntensifyEntity getIntensify(UUID playerUuid) {
        return PlayerIntensifyService.getInstance().findByPlayerUuid(playerUuid.toString()).orElse(null);
    }

    public ItemStack giveIntensifyCard(Integer level, IntensifyCardEnum intensifyCard) {
        String name = IntensifyCardEnum.getName(level, intensifyCard.getType());
        return IntensifyUtil.getIntensifyCard(name, intensifyCard.getProbability(), level);
    }

    public ItemStack giveProtectionAmulet() {
        return IntensifyUtil.getProtectionAmulet();
    }

    public ItemStack giveProtectionCard() {
        return IntensifyUtil.getProtectionCard();
    }

    public ItemStack giveSecretMedicines() {
        return IntensifyUtil.getSecretMedicines();
    }

    public ItemStack giveRyanCokes() {
        return this.giveCokes(CokesTypeEnum.RYAN_COKES);
    }

    public ItemStack giveEnchantedCokes() {
        return this.giveCokes(CokesTypeEnum.ENCHANTED_COKES);
    }

    public ItemStack giveCokes(CokesTypeEnum cokesType) {
        return IntensifyUtil.getCokes(cokesType);
    }

    public Integer getLevel(ItemStack itemStack) {
        Optional<String> levelOpt = ItemStackUtil.getPersistentData(itemStack, "level");
        if (levelOpt.isPresent()) {
            return NumberUtil.isNumericToInt(levelOpt.get(), 0);
        }
        return 0;
    }

    private static class SingletonHolder {
        private static final IntensifyApi INSTANCE = new IntensifyApi();

        private SingletonHolder() {
        }
    }
}

