/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.command.admin;

import cn.handyplus.intensify.api.IntensifyApi;
import cn.handyplus.intensify.constants.IntensifyCardEnum;
import cn.handyplus.intensify.lib.command.IHandyCommandEvent;
import cn.handyplus.intensify.lib.core.MapUtil;
import cn.handyplus.intensify.lib.util.AssertUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TransferLevelCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "transferLevel";
    }

    @Override
    public String permission() {
        return "playerIntensify.transferLevel";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player;
        if (args.length > 1) {
            Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(args[1]);
            if (!onlinePlayerOpt.isPresent()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
                return;
            }
            player = onlinePlayerOpt.get();
        } else {
            player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        }
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), BaseUtil.getLangMsg("noAir"));
        Integer level = IntensifyApi.getInstance().getLevel(itemInMainHand);
        if (level < 1) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("noLevelFailureMsg"));
            return;
        }
        ItemStack itemStack = IntensifyApi.getInstance().giveIntensifyCard(level, IntensifyCardEnum.INTENSIFY_CARD);
        itemInMainHand.setAmount(0);
        ItemStackUtil.addItem(player, itemStack, 1);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("transferLevelMsg", MapUtil.of("${item}", BaseUtil.getDisplayName(itemStack))));
    }
}

