/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.constants;

import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.constants.VersionCheckEnum;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.MapUtil;
import cn.handyplus.intensify.lib.util.HandyConfigUtil;
import cn.handyplus.intensify.util.ConfigUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.EquipmentSlot;

public enum SwordEnum {
    NETHERITE_SWORD("NETHERITE_SWORD", 8.0, 1, EquipmentSlot.HAND, "enable.sword", "sword", VersionCheckEnum.V_1_16),
    DIAMOND_SWORD("DIAMOND_SWORD", 7.0, 1, EquipmentSlot.HAND, "enable.sword", "sword", VersionCheckEnum.V_1_7),
    IRON_SWORD("IRON_SWORD", 6.0, 1, EquipmentSlot.HAND, "enable.sword", "sword", VersionCheckEnum.V_1_7),
    GOLDEN_SWORD("GOLDEN_SWORD", 4.0, 1, EquipmentSlot.HAND, "enable.sword", "sword", VersionCheckEnum.V_1_7),
    STONE_SWORD("STONE_SWORD", 5.0, 1, EquipmentSlot.HAND, "enable.sword", "sword", VersionCheckEnum.V_1_7),
    WOODEN_SWORD("WOODEN_SWORD", 4.0, 1, EquipmentSlot.HAND, "enable.sword", "sword", VersionCheckEnum.V_1_7),
    NETHERITE_HELMET("NETHERITE_HELMET", 3.0, 2, EquipmentSlot.HEAD, "enable.armor", "armor", VersionCheckEnum.V_1_16),
    NETHERITE_CHESTPLATE("NETHERITE_CHESTPLATE", 8.0, 2, EquipmentSlot.CHEST, "enable.armor", "armor", VersionCheckEnum.V_1_16),
    NETHERITE_LEGGINGS("NETHERITE_LEGGINGS", 6.0, 2, EquipmentSlot.LEGS, "enable.armor", "armor", VersionCheckEnum.V_1_16),
    NETHERITE_BOOTS("NETHERITE_BOOTS", 3.0, 2, EquipmentSlot.FEET, "enable.armor", "armor", VersionCheckEnum.V_1_16),
    DIAMOND_HELMET("DIAMOND_HELMET", 3.0, 2, EquipmentSlot.HEAD, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    DIAMOND_CHESTPLATE("DIAMOND_CHESTPLATE", 8.0, 2, EquipmentSlot.CHEST, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    DIAMOND_LEGGINGS("DIAMOND_LEGGINGS", 6.0, 2, EquipmentSlot.LEGS, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    DIAMOND_BOOTS("DIAMOND_BOOTS", 3.0, 2, EquipmentSlot.FEET, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    ELYTRA("ELYTRA", 8.0, 2, EquipmentSlot.CHEST, "enable.elytra", "elytra", VersionCheckEnum.V_1_9),
    IRON_HELMET("IRON_HELMET", 2.0, 2, EquipmentSlot.HEAD, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    IRON_CHESTPLATE("IRON_CHESTPLATE", 6.0, 2, EquipmentSlot.CHEST, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    IRON_LEGGINGS("IRON_LEGGINGS", 5.0, 2, EquipmentSlot.LEGS, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    IRON_BOOTS("IRON_BOOTS", 2.0, 2, EquipmentSlot.FEET, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    GOLDEN_HELMET("GOLDEN_HELMET", 2.0, 2, EquipmentSlot.HEAD, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    GOLDEN_CHESTPLATE("GOLDEN_CHESTPLATE", 5.0, 2, EquipmentSlot.CHEST, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    GOLDEN_LEGGINGS("GOLDEN_LEGGINGS", 3.0, 2, EquipmentSlot.LEGS, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    GOLDEN_BOOTS("GOLDEN_BOOTS", 1.0, 2, EquipmentSlot.FEET, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    CHAINMAIL_HELMET("CHAINMAIL_HELMET", 2.0, 2, EquipmentSlot.HEAD, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    CHAINMAIL_CHESTPLATE("CHAINMAIL_CHESTPLATE", 5.0, 2, EquipmentSlot.CHEST, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    CHAINMAIL_LEGGINGS("CHAINMAIL_LEGGINGS", 4.0, 2, EquipmentSlot.LEGS, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    CHAINMAIL_BOOTS("CHAINMAIL_BOOTS", 1.0, 2, EquipmentSlot.FEET, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    LEATHER_HELMET("LEATHER_HELMET", 1.0, 2, EquipmentSlot.HEAD, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    LEATHER_CHESTPLATE("LEATHER_CHESTPLATE", 3.0, 2, EquipmentSlot.CHEST, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    LEATHER_LEGGINGS("LEATHER_LEGGINGS", 2.0, 2, EquipmentSlot.LEGS, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    LEATHER_BOOTS("LEATHER_BOOTS", 1.0, 2, EquipmentSlot.FEET, "enable.armor", "armor", VersionCheckEnum.V_1_7),
    TURTLE_HELMET("TURTLE_HELMET", 2.0, 2, EquipmentSlot.HEAD, "enable.armor", "armor", VersionCheckEnum.V_1_13),
    SHIELD("SHIELD", 0.0, 3, EquipmentSlot.OFF_HAND, "enable.shield", "shield", VersionCheckEnum.V_1_9),
    NETHERITE_AXE("NETHERITE_AXE", 10.0, 4, EquipmentSlot.HAND, "enable.axe", "axe", VersionCheckEnum.V_1_16),
    DIAMOND_AXE("DIAMOND_AXE", 9.0, 4, EquipmentSlot.HAND, "enable.axe", "axe", VersionCheckEnum.V_1_7),
    TRIDENT("TRIDENT", 9.0, 5, EquipmentSlot.HAND, "enable.trident", "trident", VersionCheckEnum.V_1_13),
    BOW("BOW", 0.0, 6, EquipmentSlot.HAND, "enable.bow", "bow", VersionCheckEnum.V_1_7),
    CROSSBOW("CROSSBOW", 0.0, 7, EquipmentSlot.HAND, "enable.crossbow", "crossbow", VersionCheckEnum.V_1_14),
    MACE("MACE", 6.0, 8, EquipmentSlot.HAND, "enable.mace", "mace", VersionCheckEnum.V_1_21),
    CUSTOM("CUSTOM", 0.0, 9, EquipmentSlot.HAND, "enable.custom", "custom", VersionCheckEnum.V_1_7);

    private final String material;
    private final double amount;
    private final int type;
    private final EquipmentSlot equipmentSlot;
    private final String enableStr;
    private String typeStr;
    private final VersionCheckEnum version;

    public static SwordEnum getEnum(Material material) {
        for (SwordEnum swordEnum : SwordEnum.values()) {
            if (CUSTOM.equals((Object)swordEnum) || !swordEnum.getMaterial().equals(material.name()) || !swordEnum.getEnable()) continue;
            return swordEnum;
        }
        Map<String, List<String>> customMaterialMap = IntensifyUtil.getCustomMaterialMap();
        if (MapUtil.isEmpty(customMaterialMap)) {
            return null;
        }
        for (String key : customMaterialMap.keySet()) {
            if (!CollUtil.contains(customMaterialMap.get(key), material.name())) continue;
            CUSTOM.setTypeStr(key);
            return CUSTOM;
        }
        return null;
    }

    public static boolean isEnable(SwordEnum swordEnum) {
        switch (swordEnum.type) {
            case 1: {
                return ConfigUtil.PARTICLE_CONFIG.getBoolean("enable.sword");
            }
            case 4: {
                return ConfigUtil.PARTICLE_CONFIG.getBoolean("enable.axe");
            }
            case 5: {
                return ConfigUtil.PARTICLE_CONFIG.getBoolean("enable.trident");
            }
            case 6: {
                return ConfigUtil.PARTICLE_CONFIG.getBoolean("enable.bow");
            }
            case 7: {
                return ConfigUtil.PARTICLE_CONFIG.getBoolean("enable.crossbow");
            }
        }
        return false;
    }

    public static Map<Integer, String> getParticleMap(SwordEnum swordEnum) {
        Map<Object, Object> map = new HashMap();
        switch (swordEnum.type) {
            case 1: {
                map = HandyConfigUtil.getStringMapChild(ConfigUtil.PARTICLE_CONFIG, "sword");
                break;
            }
            case 4: {
                map = HandyConfigUtil.getStringMapChild(ConfigUtil.PARTICLE_CONFIG, "axe");
                break;
            }
            case 5: {
                map = HandyConfigUtil.getStringMapChild(ConfigUtil.PARTICLE_CONFIG, "trident");
                break;
            }
            case 6: {
                map = HandyConfigUtil.getStringMapChild(ConfigUtil.PARTICLE_CONFIG, "bow");
                break;
            }
            case 7: {
                map = HandyConfigUtil.getStringMapChild(ConfigUtil.PARTICLE_CONFIG, "crossbow");
                break;
            }
        }
        return map.entrySet().stream().collect(Collectors.toMap(entry -> Integer.parseInt((String)entry.getKey()), Map.Entry::getValue));
    }

    public static List<String> getMaterialList() {
        ArrayList<String> materialList = new ArrayList<String>();
        VersionCheckEnum version = VersionCheckEnum.getEnum();
        for (SwordEnum swordEnum : SwordEnum.values()) {
            if (CUSTOM.equals((Object)swordEnum) || !swordEnum.getEnable() || version.getVersionId() < swordEnum.getVersion().getVersionId()) continue;
            materialList.add(swordEnum.getMaterial());
        }
        Map<String, List<String>> customMaterialMap = IntensifyUtil.getCustomMaterialMap();
        if (MapUtil.isNotEmpty(customMaterialMap)) {
            List customList = customMaterialMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            materialList.addAll(customList);
        }
        return materialList;
    }

    private boolean getEnable() {
        return BaseConstants.CONFIG.getBoolean(this.enableStr, true);
    }

    @Generated
    public String getMaterial() {
        return this.material;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public int getType() {
        return this.type;
    }

    @Generated
    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    @Generated
    public String getEnableStr() {
        return this.enableStr;
    }

    @Generated
    public String getTypeStr() {
        return this.typeStr;
    }

    @Generated
    public VersionCheckEnum getVersion() {
        return this.version;
    }

    @Generated
    private SwordEnum(String material, double amount, int type, EquipmentSlot equipmentSlot, String enableStr, String typeStr, VersionCheckEnum version) {
        this.material = material;
        this.amount = amount;
        this.type = type;
        this.equipmentSlot = equipmentSlot;
        this.enableStr = enableStr;
        this.typeStr = typeStr;
        this.version = version;
    }

    @Generated
    public void setTypeStr(String typeStr) {
        this.typeStr = typeStr;
    }
}

