/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.intensify;

import cn.handyplus.intensify.PlayerIntensify;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.lib.constants.AttributeCompatEnum;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.MapUtil;
import cn.handyplus.intensify.lib.core.NumberUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemMetaUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.util.ConfigUtil;
import de.tr7zw.nbtapi.NBT;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public interface IntensifyService {
    public void intensifyAttribute(ItemStack var1, int var2, double var3, SwordEnum var5);

    default public boolean isEnable(String type) {
        return BaseConstants.CONFIG.getBoolean("extra." + type, true);
    }

    default public BigDecimal getLevelAttr(int level, String type) {
        BigDecimal levelBigDecimal = new BigDecimal(String.valueOf(level - 10));
        double extraAttr = BaseConstants.CONFIG.getDouble("extraAttr." + type, 0.1);
        return levelBigDecimal.multiply(BigDecimal.valueOf(extraAttr));
    }

    default public void intensify(ItemStack itemStack, int level, double amount, SwordEnum swordEnum) {
        if (this.intensifyNbt(swordEnum.getTypeStr(), itemStack, level)) {
            this.intensifyLore(swordEnum.getTypeStr(), itemStack, level);
            return;
        }
        if (this.intensifyLore(swordEnum.getTypeStr(), itemStack, level)) {
            return;
        }
        if (this.intensifyAttr(swordEnum, itemStack, level)) {
            return;
        }
        this.intensifyAttribute(itemStack, level, amount, swordEnum);
    }

    default public boolean intensifyLore(String type, ItemStack itemStack, int level) {
        String loreType;
        if (!ConfigUtil.LORE_CONFIG.getBoolean("enable." + type)) {
            return false;
        }
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        List originalLore = itemMeta.getLore();
        if (CollUtil.isEmpty(originalLore)) {
            originalLore = new ArrayList();
        }
        Optional<String> oldLevelOpt = ItemMetaUtil.getPersistentData(itemMeta, "level");
        List oldLevelList = new ArrayList();
        if (oldLevelOpt.isPresent()) {
            oldLevelList = ConfigUtil.LORE_CONFIG.getStringList(type + "." + oldLevelOpt.get());
            ItemStack oldItemStack = ItemStackUtil.getItemStack("STONE", "old", oldLevelList);
            ItemMeta oldItemMeta = ItemStackUtil.getItemMeta(oldItemStack);
            oldLevelList = oldItemMeta.getLore();
        }
        if (oldLevelList == null) {
            oldLevelList = new ArrayList();
        }
        List loreList = ConfigUtil.LORE_CONFIG.getStringList(type + "." + level);
        switch (loreType = ConfigUtil.LORE_CONFIG.getString("loreType", "replace")) {
            case "addLater": {
                originalLore.removeAll(oldLevelList);
                originalLore.addAll(loreList);
                break;
            }
            case "addBefore": {
                originalLore.removeAll(oldLevelList);
                loreList.addAll(originalLore);
                originalLore = loreList;
                break;
            }
            case "replace": {
                originalLore = loreList;
            }
        }
        itemMeta.setLore(BaseUtil.replaceChatColor(originalLore));
        itemStack.setItemMeta(itemMeta);
        return true;
    }

    default public boolean intensifyNbt(String type, ItemStack itemStack, int level) {
        if (!PlayerIntensify.USE_NBT_API) {
            return false;
        }
        if (!ConfigUtil.NBT_CONFIG.getBoolean("enable." + type)) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        Optional<String> oldLevelOpt = ItemMetaUtil.getPersistentData(itemMeta, "level");
        List oldLevelList = oldLevelOpt.map(s -> ConfigUtil.NBT_CONFIG.getStringList(type + "." + s)).orElseGet(ArrayList::new);
        List newNbtList = ConfigUtil.NBT_CONFIG.getStringList(type + "." + level);
        NBT.modify((ItemStack)itemStack, nbt -> {
            Map<String, String> nbtMap;
            for (String oldLevelNbt : oldLevelList) {
                nbtMap = this.getNbtKeyAndValue(oldLevelNbt);
                for (String key : nbtMap.keySet()) {
                    nbt.removeKey(key);
                }
            }
            for (String newNbt : newNbtList) {
                nbtMap = this.getNbtKeyAndValue(newNbt);
                for (String key : nbtMap.keySet()) {
                    Double newValue = NumberUtil.isNumericToDouble(nbtMap.get(key));
                    if (newValue != null) {
                        nbt.setDouble(key, newValue);
                        continue;
                    }
                    nbt.setString(key, nbtMap.get(key));
                }
            }
        });
        return true;
    }

    default public Map<String, String> getNbtKeyAndValue(String inputStr) {
        int lastColonIndex = inputStr.lastIndexOf(58);
        String key = inputStr.substring(0, lastColonIndex).trim();
        String value = inputStr.substring(lastColonIndex + 1).trim();
        return MapUtil.of(key, value);
    }

    default public boolean intensifyAttr(SwordEnum swordEnum, ItemStack itemStack, int newLevel) {
        String attrType;
        String type = swordEnum.getTypeStr();
        if (!ConfigUtil.ATTR_CONFIG.getBoolean("enable." + type)) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        int oldLevel = ItemMetaUtil.getPersistentData(itemMeta, "level").map(Integer::parseInt).orElse(0);
        List newAttrList = ConfigUtil.ATTR_CONFIG.getStringList(type + "." + newLevel);
        HashMap<String, Double> attrMap = new HashMap<String, Double>();
        for (String newAttr : newAttrList) {
            String[] split = newAttr.split(":");
            attrMap.put(split[0], this.getRandomValue(split[1]));
        }
        HashMap<EquipmentSlot, Map<String, Double>> slotAttrList = new HashMap<EquipmentSlot, Map<String, Double>>();
        slotAttrList.put(swordEnum.getEquipmentSlot(), attrMap);
        switch (attrType = ConfigUtil.ATTR_CONFIG.getString("attrType", "set")) {
            case "set": 
            case "replace": {
                List oldLevelList = ConfigUtil.ATTR_CONFIG.getStringList(type + "." + oldLevel);
                for (String oldAttr : oldLevelList) {
                    String[] split = oldAttr.split(":");
                    itemMeta.removeAttributeModifier(AttributeCompatEnum.getByName(split[0]).resolve());
                }
                itemStack.setItemMeta(itemMeta);
                AttributeCompatEnum.setAttributeModifier(slotAttrList, itemStack);
                break;
            }
            case "add": {
                if (oldLevel > newLevel) {
                    AttributeCompatEnum.addAttributeModifier(this.buildMinusAttrMap(type, swordEnum, oldLevel, newLevel), itemStack);
                    break;
                }
                if (oldLevel >= newLevel) break;
                for (Map<EquipmentSlot, Map<String, Double>> upMap : this.buildPlusAttrMap(type, swordEnum, oldLevel, newLevel)) {
                    AttributeCompatEnum.addAttributeModifier(upMap, itemStack);
                }
                break;
            }
        }
        return true;
    }

    default public List<Map<EquipmentSlot, Map<String, Double>>> buildPlusAttrMap(String type, SwordEnum swordEnum, int oldLevel, int newLevel) {
        ArrayList<Map<EquipmentSlot, Map<String, Double>>> result = new ArrayList<Map<EquipmentSlot, Map<String, Double>>>();
        for (int i = oldLevel + 1; i <= newLevel; ++i) {
            List upList = ConfigUtil.ATTR_CONFIG.getStringList(type + "." + i);
            HashMap<String, Double> upAttrMap = new HashMap<String, Double>();
            for (String upAttr : upList) {
                String[] split = upAttr.split(":");
                upAttrMap.put(split[0], this.getRandomValue(split[1]));
            }
            HashMap<EquipmentSlot, HashMap<String, Double>> upSlotMap = new HashMap<EquipmentSlot, HashMap<String, Double>>();
            upSlotMap.put(swordEnum.getEquipmentSlot(), upAttrMap);
            result.add(upSlotMap);
        }
        return result;
    }

    default public Map<EquipmentSlot, Map<String, Double>> buildMinusAttrMap(String type, SwordEnum swordEnum, int oldLevel, int newLevel) {
        HashMap<EquipmentSlot, Map<String, Double>> minusSlotAttrList = new HashMap<EquipmentSlot, Map<String, Double>>();
        HashMap<String, Double> minusAttrMap = new HashMap<String, Double>();
        for (int i = newLevel + 1; i <= oldLevel; ++i) {
            List minusList = ConfigUtil.ATTR_CONFIG.getStringList(type + "." + i);
            for (String minusAttr : minusList) {
                String[] split = minusAttr.split(":");
                double value = this.getRandomValue(split[1]) * -1.0;
                minusAttrMap.merge(split[0], value, Double::sum);
            }
        }
        minusSlotAttrList.put(swordEnum.getEquipmentSlot(), minusAttrMap);
        return minusSlotAttrList;
    }

    default public double getRandomValue(String valueStr) {
        if (!valueStr.contains("~")) {
            return NumberUtil.isNumericToDouble(valueStr, 0.0);
        }
        List<String> valueStrList = StrUtil.strToStrList(valueStr, "~");
        Double one = NumberUtil.isNumericToDouble(valueStrList.get(0));
        Double two = NumberUtil.isNumericToDouble(valueStrList.get(valueStrList.size() - 1));
        return one + (two - one) * new Random().nextDouble();
    }
}

