/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.intensify.impl;

import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.intensify.IntensifyService;
import cn.handyplus.intensify.lib.constants.AttributeCompatEnum;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.LegacyUtil;
import java.math.BigDecimal;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShieldIntensifyServiceImpl
implements IntensifyService {
    private static final String TYPE = "shield";

    @Override
    public void intensifyAttribute(ItemStack itemStack, int level, double amount, SwordEnum swordEnum) {
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        itemMeta.removeAttributeModifier(AttributeCompatEnum.MAX_HEALTH.resolve());
        itemMeta.removeEnchant(LegacyUtil.getDurability());
        itemMeta.addEnchant(LegacyUtil.getDurability(), level < 11 ? level : 10, true);
        if (level > IntensifyConstants.EXTRA_ATTR_LEVEL && this.isEnable(TYPE)) {
            BigDecimal armor = this.getLevelAttr(level, TYPE);
            AttributeModifier genericMaxHealth = LegacyUtil.getAttributeModifier("generic.max_health", armor.doubleValue(), AttributeModifier.Operation.ADD_NUMBER, swordEnum.getEquipmentSlot());
            itemMeta.addAttributeModifier(AttributeCompatEnum.MAX_HEALTH.resolve(), genericMaxHealth);
        }
        itemStack.setItemMeta(itemMeta);
    }
}

