/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib;

import cn.handyplus.intensify.lib.annotation.TableName;
import cn.handyplus.intensify.lib.command.HandyCommandWrapper;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.constants.VersionCheckEnum;
import cn.handyplus.intensify.lib.core.ClassUtil;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.db.Db;
import cn.handyplus.intensify.lib.db.SqlManagerUtil;
import cn.handyplus.intensify.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.intensify.lib.expand.bstats.bukkit.Metrics;
import cn.handyplus.intensify.lib.expand.bstats.charts.CustomChart;
import cn.handyplus.intensify.lib.inventory.HandyInventoryUtil;
import cn.handyplus.intensify.lib.inventory.HandyInventoryWrapper;
import cn.handyplus.intensify.lib.inventory.InventoryViewUtil;
import cn.handyplus.intensify.lib.util.BcUtil;
import cn.handyplus.intensify.lib.util.HandyHttpUtil;
import cn.handyplus.intensify.lib.util.LegacyUtil;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class InitApi {
    private static final InitApi INSTANCE = new InitApi();
    public static JavaPlugin PLUGIN;

    private InitApi() {
    }

    public static InitApi getInstance(JavaPlugin plugin) {
        PLUGIN = plugin;
        BaseConstants.VERSION_CHECK_ENUM = VersionCheckEnum.getEnum();
        BaseConstants.VERSION_ID = BaseConstants.VERSION_CHECK_ENUM.getVersionId();
        HandySchedulerUtil.init((Plugin)plugin);
        LegacyUtil.initClasses();
        InventoryViewUtil.init(BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_21.getVersionId());
        return INSTANCE;
    }

    public InitApi initCommand(String packageName) {
        HandyCommandWrapper.initCommand(packageName);
        return this;
    }

    public InitApi initListener(String packageName) {
        return this.initListener(packageName, null);
    }

    public InitApi initListener(String packageName, List<String> ignoreList) {
        HandyInventoryWrapper.initListener(packageName, ignoreList);
        return this;
    }

    public InitApi initClickEvent(String packageName) {
        HandyInventoryWrapper.initClickEvent(packageName);
        return this;
    }

    public InitApi checkVersion() {
        if (BaseConstants.IS_CHECK_UPDATE) {
            HandyHttpUtil.checkVersion(null);
        }
        return this;
    }

    public InitApi addMetrics(int pluginId) {
        return this.addMetrics(pluginId, null);
    }

    public InitApi addMetrics(int pluginId, List<CustomChart> customCharts) {
        try {
            Metrics metrics = new Metrics((Plugin)PLUGIN, pluginId);
            if (CollUtil.isNotEmpty(customCharts)) {
                for (CustomChart customChart : customCharts) {
                    metrics.addCustomChart(customChart);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public InitApi enableSql(String packageName) {
        List<Class<?>> tableList = ClassUtil.getInstance().getClassByAnnotation(packageName, TableName.class);
        if (CollUtil.isEmpty(tableList)) {
            return this;
        }
        SqlManagerUtil.getInstance().enableSql();
        for (Class<?> aClass : tableList) {
            if (!aClass.getAnnotation(TableName.class).create()) continue;
            Db.use(aClass).createTable();
        }
        return this;
    }

    public InitApi enableBc() {
        BcUtil.registerOut();
        return this;
    }

    public static void disable() {
        SqlManagerUtil.getInstance().close();
        HandySchedulerUtil.cancelTask();
        if (!HandySchedulerUtil.isFolia()) {
            HandyInventoryUtil.closeHandyInventory();
        }
    }
}

