/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.command;

import cn.handyplus.intensify.lib.InitApi;
import cn.handyplus.intensify.lib.annotation.HandyCommand;
import cn.handyplus.intensify.lib.annotation.HandySubCommand;
import cn.handyplus.intensify.lib.command.HandyCommandFactory;
import cn.handyplus.intensify.lib.command.HandySubCommandParam;
import cn.handyplus.intensify.lib.command.IHandyCommandEvent;
import cn.handyplus.intensify.lib.core.ClassUtil;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.permissions.DefaultPermissions;
import org.jetbrains.annotations.NotNull;

public final class HandyCommandWrapper {
    private HandyCommandWrapper() {
    }

    public static void initCommand(String packageName) {
        Map<Class<?>, List<Method>> methodsMap;
        List<Class<IHandyCommandEvent>> handyCommandEventList;
        List<Class<?>> commandList = ClassUtil.getInstance().getClassByAnnotation(packageName, HandyCommand.class);
        if (CollUtil.isNotEmpty(commandList)) {
            for (Class<?> aClass : commandList) {
                HandyCommand handyCommand = aClass.getAnnotation(HandyCommand.class);
                PluginCommand pluginCommand = Bukkit.getPluginCommand((String)handyCommand.name());
                if (pluginCommand == null) continue;
                if (aClass.newInstance() instanceof CommandExecutor) {
                    pluginCommand.setExecutor((CommandExecutor)aClass.newInstance());
                }
                if (aClass.newInstance() instanceof TabExecutor) {
                    pluginCommand.setTabCompleter((TabCompleter)((TabExecutor)aClass.newInstance()));
                }
                if (handyCommand.aliases().length > 0) {
                    pluginCommand.setAliases(Arrays.asList(handyCommand.aliases()));
                }
                pluginCommand.setDescription(handyCommand.description());
                pluginCommand.setUsage(handyCommand.usage());
                pluginCommand.setPermissionMessage(handyCommand.permissionMessage());
                if (!StrUtil.isNotEmpty(handyCommand.permission())) continue;
                pluginCommand.setPermission(handyCommand.permission());
                DefaultPermissions.registerPermission((String)handyCommand.permission(), null, (PermissionDefault)handyCommand.PERMISSION_DEFAULT());
            }
        }
        if (CollUtil.isNotEmpty(handyCommandEventList = ClassUtil.getInstance().getClassByIsAssignableFrom(packageName, IHandyCommandEvent.class))) {
            ArrayList<IHandyCommandEvent> handyCommandEvents = new ArrayList<IHandyCommandEvent>();
            for (Class clazz : handyCommandEventList) {
                handyCommandEvents.add((IHandyCommandEvent)clazz.newInstance());
            }
            HandyCommandFactory.getInstance().init(handyCommandEvents);
        }
        if (!(methodsMap = ClassUtil.getInstance().getMethodByAnnotation(packageName, HandySubCommand.class)).isEmpty()) {
            ArrayList<HandySubCommandParam> subCommandParamList = new ArrayList<HandySubCommandParam>();
            for (Class<?> clazz : methodsMap.keySet()) {
                for (Method method : methodsMap.get(clazz)) {
                    subCommandParamList.add(HandyCommandWrapper.getHandySubCommandParam(clazz, method));
                }
            }
            Map<String, Map<String, HandySubCommandParam>> map = subCommandParamList.stream().collect(Collectors.groupingBy(HandySubCommandParam::getCommand, Collectors.groupingBy(HandySubCommandParam::getSubCommand, Collectors.collectingAndThen(Collectors.toList(), value -> (HandySubCommandParam)value.get(0)))));
            HandyCommandFactory.getInstance().initSubCommand(map);
        }
    }

    public static boolean onSubCommand(String command, CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        return HandyCommandFactory.getInstance().onSubCommand(command, sender, cmd, label, args, noPermission);
    }

    public static boolean onCommand(CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        return HandyCommandFactory.getInstance().onCommand(sender, cmd, label, args, noPermission);
    }

    public static void injectCommand(String cmd) {
        HandyCommandWrapper.injectCommand(Collections.singletonList(cmd));
    }

    public static void injectCommand(List<String> cmdList) {
        Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
        bukkitCommandMap.setAccessible(true);
        CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
        for (String cmd : cmdList) {
            Command myCommand = new Command(cmd){

                public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
                    return true;
                }
            };
            commandMap.register(InitApi.PLUGIN.getDescription().getName(), myCommand);
        }
    }

    private static HandySubCommandParam getHandySubCommandParam(Class<?> aClass, Method method) {
        HandySubCommand handySubCommand = method.getAnnotation(HandySubCommand.class);
        HandySubCommandParam param = new HandySubCommandParam();
        param.setCommand(handySubCommand.mainCommand().toLowerCase().trim());
        param.setSubCommand(handySubCommand.subCommand().toLowerCase().trim());
        param.setPermission(handySubCommand.permission().trim());
        param.setAClass(aClass);
        param.setMethod(method);
        return param;
    }
}

