/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.core;

import cn.handyplus.intensify.lib.core.MapUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public final class BeanUtil {
    private BeanUtil() {
    }

    public static Map<String, Object> beanToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = MapUtil.of();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if ("class".equals(key)) continue;
                map.put(key, property.getReadMethod().invoke(obj, new Object[0]));
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "beanToMap \u53d1\u751f\u5f02\u5e38", e);
        }
        return map;
    }

    public static <T> T mapToBean(Class<T> clazz, Map<?, ?> map) {
        T obj = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName)) continue;
                descriptor.getWriteMethod().invoke(obj, map.get(propertyName));
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "mapToBean \u53d1\u751f\u5f02\u5e38", e);
        }
        return obj;
    }

    public static <T> T createBean(Class<T> clazz) {
        T obj = null;
        try {
            obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "createBean \u53d1\u751f\u5f02\u5e38", e);
        }
        return obj;
    }
}

