/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.core;

import cn.handyplus.intensify.lib.core.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollUtil {
    private CollUtil() {
    }

    public static <T> String listToStr(List<T> list) {
        return CollUtil.listToStr(list, ",");
    }

    public static <T> String listToStr(List<T> list, CharSequence delimiter) {
        if (CollUtil.isEmpty(list)) {
            return "";
        }
        return list.stream().map(String::valueOf).collect(Collectors.joining(delimiter));
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollUtil.isEmpty(collection);
    }

    public static boolean equals(List<String> list, List<String> list1) {
        if (list == list1) {
            return true;
        }
        if (list == null) {
            return false;
        }
        return list.equals(list1);
    }

    public static <T> List<List<T>> partition(List<T> list, int toIndex) {
        ArrayList<List<T>> listGroup = new ArrayList<List<T>>();
        int listSize = list.size();
        for (int i = 0; i < list.size(); i += toIndex) {
            if (i + toIndex > listSize) {
                toIndex = listSize - i;
            }
            List<T> newList = list.subList(i, i + toIndex);
            listGroup.add(newList);
        }
        return listGroup;
    }

    public static String getContainsStr(List<String> list, String str) {
        if (CollUtil.isEmpty(list) || StrUtil.isEmpty(str)) {
            return null;
        }
        for (String string : list) {
            if (!string.contains(str)) continue;
            return string;
        }
        return null;
    }

    public static String getStr(List<String> list, String str) {
        if (CollUtil.isEmpty(list) || StrUtil.isEmpty(str)) {
            return null;
        }
        int i = list.indexOf(str);
        return i != -1 ? list.get(i) : null;
    }

    public static <T> List<List<T>> splitList(List<T> list, int splitSize) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        int maxSize = (list.size() + splitSize - 1) / splitSize;
        return ((Stream)Stream.iterate(0, n -> n + 1).limit(maxSize).parallel()).map(a -> list.parallelStream().skip((long)a.intValue() * (long)splitSize).limit(splitSize).collect(Collectors.toList())).filter(b -> !b.isEmpty()).collect(Collectors.toList());
    }

    public static <T> T randomElement(List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        return list.get(new Random().nextInt(list.size()));
    }

    public static boolean contains(List<String> list, String target) {
        return list.stream().anyMatch(target::equalsIgnoreCase);
    }
}

