/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.hologram;

import cn.handyplus.intensify.lib.core.StrUtil;
import eu.decentsoftware.holograms.api.DHAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class DecentHologramsUtil {
    private static final Map<Location, String> DECENT_HOLOGRAMS_HD_CACHE = new HashMap<Location, String>();

    private DecentHologramsUtil() {
    }

    protected static void create(List<String> textLineList, Location location) {
        String name = UUID.randomUUID().toString();
        DHAPI.createHologram((String)name, (Location)location, textLineList);
        DECENT_HOLOGRAMS_HD_CACHE.put(location, name);
    }

    protected static void delete(Location location) {
        String name = DECENT_HOLOGRAMS_HD_CACHE.get(location);
        if (StrUtil.isEmpty(name)) {
            return;
        }
        DHAPI.removeHologram((String)name);
        DECENT_HOLOGRAMS_HD_CACHE.remove(location);
    }

    protected static void deleteAll() {
        for (Location location : DECENT_HOLOGRAMS_HD_CACHE.keySet()) {
            String name = DECENT_HOLOGRAMS_HD_CACHE.get(location);
            if (!StrUtil.isNotEmpty(name)) continue;
            DHAPI.removeHologram((String)name);
        }
        DECENT_HOLOGRAMS_HD_CACHE.clear();
    }
}

