/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.hologram;

import cn.handyplus.intensify.lib.hologram.CmiUtil;
import cn.handyplus.intensify.lib.hologram.DecentHologramsUtil;
import cn.handyplus.intensify.lib.hologram.FancyHologramsUtil;
import cn.handyplus.intensify.lib.hologram.HolographicDisplaysUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class HdUtil {
    private static boolean USE_HOLOGRAPHIC_DISPLAYS;
    private static boolean USE_DECENT_HOLOGRAMS;
    private static boolean USE_CMI;
    private static boolean USE_FANCY_HOLOGRAMS;

    private HdUtil() {
    }

    public static boolean init() {
        Optional<Plugin> useDh = BaseUtil.hook("DecentHolograms");
        if (useDh.isPresent()) {
            USE_DECENT_HOLOGRAMS = useDh.get().isEnabled();
            MessageUtil.sendConsoleMessage("hook DecentHolograms success");
            return true;
        }
        Optional<Plugin> useHd = BaseUtil.hook("HolographicDisplays");
        if (useHd.isPresent()) {
            USE_HOLOGRAPHIC_DISPLAYS = useHd.get().isEnabled();
            MessageUtil.sendConsoleMessage("hook HolographicDisplays success");
            return true;
        }
        Optional<Plugin> useCmi = BaseUtil.hook("CMI");
        if (useCmi.isPresent()) {
            USE_CMI = useCmi.get().isEnabled();
            MessageUtil.sendConsoleMessage("hook cmi success");
            return true;
        }
        Optional<Plugin> useFancyHolograms = BaseUtil.hook("FancyHolograms");
        if (useFancyHolograms.isPresent()) {
            USE_FANCY_HOLOGRAMS = useFancyHolograms.get().isEnabled();
            MessageUtil.sendConsoleMessage("hook FancyHolograms success");
            return true;
        }
        MessageUtil.sendConsoleMessage("hook Holograms error");
        return false;
    }

    public static void create(List<String> textLineList, Location location, String material, int customModelData) {
        if (location == null) {
            return;
        }
        if (USE_DECENT_HOLOGRAMS) {
            DecentHologramsUtil.create(textLineList, location);
            return;
        }
        if (USE_HOLOGRAPHIC_DISPLAYS) {
            HolographicDisplaysUtil.create(textLineList, location, material, customModelData);
            return;
        }
        if (USE_CMI) {
            CmiUtil.create(textLineList, location);
            return;
        }
        if (USE_FANCY_HOLOGRAMS) {
            FancyHologramsUtil.create(textLineList, location);
        }
    }

    public static void deleteAll() {
        if (USE_DECENT_HOLOGRAMS) {
            DecentHologramsUtil.deleteAll();
            return;
        }
        if (USE_HOLOGRAPHIC_DISPLAYS) {
            HolographicDisplaysUtil.deleteAll();
            return;
        }
        if (USE_CMI) {
            CmiUtil.deleteAll();
            return;
        }
        if (USE_FANCY_HOLOGRAMS) {
            FancyHologramsUtil.deleteAll();
        }
    }

    public static void delete(Location location) {
        if (location == null) {
            return;
        }
        if (USE_DECENT_HOLOGRAMS) {
            DecentHologramsUtil.delete(location);
            return;
        }
        if (USE_HOLOGRAPHIC_DISPLAYS) {
            HolographicDisplaysUtil.delete(location);
            return;
        }
        if (USE_CMI) {
            CmiUtil.delete(location);
            return;
        }
        if (USE_FANCY_HOLOGRAMS) {
            FancyHologramsUtil.delete(location);
        }
    }
}

