/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.hologram;

import cn.handyplus.intensify.lib.InitApi;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HolographicDisplaysUtil {
    private HolographicDisplaysUtil() {
    }

    protected static void create(List<String> textLineList, Location location, String material, int customModelData) {
        Hologram hologram = HologramsAPI.createHologram((Plugin)InitApi.PLUGIN, (Location)location);
        hologram.clearLines();
        if (StrUtil.isNotEmpty(material)) {
            ItemStack itemStack = ItemStackUtil.getItemStack(material, null, null, false, customModelData);
            hologram.appendItemLine(itemStack);
        }
        for (String textLine : textLineList) {
            hologram.appendTextLine(BaseUtil.replaceChatColor(textLine));
        }
    }

    protected static void delete(Location location) {
        for (Hologram hologram : HologramsAPI.getHolograms((Plugin)InitApi.PLUGIN)) {
            Location hdLocation = hologram.getLocation();
            if (hdLocation.getX() != location.getX() || hdLocation.getY() != location.getY() || hdLocation.getZ() != location.getZ()) continue;
            hologram.delete();
            return;
        }
    }

    protected static void deleteAll() {
        for (Hologram hologram : HologramsAPI.getHolograms((Plugin)InitApi.PLUGIN)) {
            hologram.delete();
        }
    }
}

