/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.util;

import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.constants.VersionCheckEnum;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.expand.XMaterial;
import cn.handyplus.intensify.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemMetaUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;

public final class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static String itemStackSerialize(ItemStack itemStack) {
        YamlConfiguration yml = new YamlConfiguration();
        yml.set("item", (Object)itemStack);
        return yml.saveToString();
    }

    public static ItemStack itemStackDeserialize(String str) {
        return ItemStackUtil.itemStackDeserialize(str, Material.AIR);
    }

    public static ItemStack itemStackDeserialize(String str, Material material) {
        ItemStack item;
        YamlConfiguration yml = new YamlConfiguration();
        try {
            yml.loadFromString(str);
            item = yml.getItemStack("item", new ItemStack(material));
        }
        catch (Exception ex) {
            item = new ItemStack(material);
        }
        return item;
    }

    public static ItemStack getItemStack(String material) {
        return ItemStackUtil.getItemStack(material, null, null);
    }

    public static ItemStack getItemStack(String material, String displayName) {
        return ItemStackUtil.getItemStack(material, displayName, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, false);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, 0);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant, int customModelData) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, false);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant, int customModelData, boolean hideFlag) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, replaceMap, false);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap, boolean hideEnchant) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, replaceMap, hideEnchant, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap, boolean hideEnchant, String customData) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, replaceMap, hideEnchant, customData, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap, boolean hideEnchant, String customData, String tooltipStyle) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, replaceMap, hideEnchant, customData, null, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap, boolean hideEnchant, String customData, String tooltipStyle, String itemModel) {
        ItemStack itemStack = ItemStackUtil.getItemByMaterial(material);
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        if (StrUtil.isNotEmpty(displayName)) {
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(displayName));
            if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId()) {
                itemMeta.setItemName(itemMeta.getDisplayName());
            }
        }
        if (CollUtil.isNotEmpty(loreList)) {
            itemMeta.setLore(BaseUtil.replaceChatColor(ItemStackUtil.loreReplaceMap(loreList, replaceMap)));
        }
        if (isEnchant) {
            ItemMetaUtil.setEnchant(itemMeta);
        }
        if (hideEnchant) {
            ItemMetaUtil.hideEnchant(itemMeta);
        }
        if (hideFlag) {
            ItemMetaUtil.hideAttributes(itemMeta);
        }
        ItemMetaUtil.setPersistentData(itemMeta, customData, "system");
        ItemMetaUtil.setCustomModelData(itemMeta, customModelData);
        ItemMetaUtil.setTooltipStyle(itemMeta, tooltipStyle);
        ItemMetaUtil.setItemModel(itemMeta, itemModel);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static Boolean removeItem(Player player, ItemStack itemStack, Integer amount) {
        return ItemStackUtil.removeItem(player, itemStack, amount, true);
    }

    public static Boolean removeItem(Player player, ItemStack itemStack, Integer amount, boolean strict) {
        if (player == null || !player.isOnline()) {
            return false;
        }
        if (amount < 1) {
            throw new RuntimeException("\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570: " + amount);
        }
        PlayerInventory playerInventory = player.getInventory();
        ItemStack[] contents = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8_8.getVersionId() ? playerInventory.getContents() : playerInventory.getStorageContents();
        int num = 0;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : contents) {
            if (item == null || Material.AIR.equals((Object)item.getType()) || (strict ? !item.isSimilar(itemStack) : !ItemStackUtil.isSimilar(item, itemStack))) continue;
            items.add(item);
            if ((num += item.getAmount()) >= amount) break;
        }
        if (num == amount) {
            for (ItemStack item : items) {
                playerInventory.removeItem(new ItemStack[]{item});
            }
            return true;
        }
        if (num > amount) {
            for (ItemStack item : items) {
                if (amount == 0) {
                    return true;
                }
                if (amount >= item.getAmount()) {
                    amount = amount - item.getAmount();
                    playerInventory.removeItem(new ItemStack[]{item});
                    continue;
                }
                item.setAmount(item.getAmount() - amount);
                amount = 0;
            }
            return true;
        }
        return false;
    }

    public static int getItemAmount(Player player, ItemStack itemStack) {
        return ItemStackUtil.getItemAmount(player, itemStack, true);
    }

    public static int getItemAmount(Player player, ItemStack itemStack, boolean strict) {
        if (player == null || !player.isOnline()) {
            return 0;
        }
        PlayerInventory playerInventory = player.getInventory();
        ItemStack[] contents = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8_8.getVersionId() ? playerInventory.getContents() : playerInventory.getStorageContents();
        int num = 0;
        for (ItemStack item : contents) {
            if (item == null || Material.AIR.equals((Object)item.getType()) || (strict ? !item.isSimilar(itemStack) : !ItemStackUtil.isSimilar(item, itemStack))) continue;
            num += item.getAmount();
        }
        return num;
    }

    public static Boolean containsItem(PlayerInventory playerInventory, ItemStack itemStack, Integer amount, boolean strict) {
        ItemStack[] contents = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8_8.getVersionId() ? playerInventory.getContents() : playerInventory.getStorageContents();
        int num = 0;
        for (ItemStack item : contents) {
            if (item != null && !Material.AIR.equals((Object)item.getType()) && !(!strict ? !ItemStackUtil.isSimilar(item, itemStack) : !item.isSimilar(itemStack)) && (num += item.getAmount()) >= amount) break;
        }
        return num >= amount;
    }

    public static boolean addItem(Player player, ItemStack itemStack) {
        return ItemStackUtil.addItem(player, itemStack, BaseUtil.getMsgNotColor("addItemMsg"));
    }

    public static boolean addItem(Player player, String itemStackStr) {
        return ItemStackUtil.addItem(player, ItemStackUtil.itemStackDeserialize(itemStackStr), BaseUtil.getMsgNotColor("addItemMsg"));
    }

    public static boolean addItem(Player player, ItemStack itemStack, String msg) {
        HashMap dropItemMap = player.getInventory().addItem(new ItemStack[]{itemStack});
        if (dropItemMap.isEmpty()) {
            return false;
        }
        PlayerSchedulerUtil.dropItem(player, new ArrayList<ItemStack>(dropItemMap.values()));
        MessageUtil.sendMessage(player, msg);
        return true;
    }

    public static boolean addItem(Player player, ItemStack itemStack, int amount) {
        return ItemStackUtil.addItem(player, itemStack, amount, BaseUtil.getMsgNotColor("addItemMsg"));
    }

    public static boolean addItem(Player player, String itemStackStr, int amount) {
        return ItemStackUtil.addItem(player, ItemStackUtil.itemStackDeserialize(itemStackStr), amount, BaseUtil.getMsgNotColor("addItemMsg"));
    }

    public static boolean addItem(Player player, ItemStack itemStack, int amount, String msg) {
        if (Material.AIR.equals((Object)itemStack.getType())) {
            return false;
        }
        List<ItemStack> dropItemList = ItemStackUtil.addItemReturnDropItemMap(player, itemStack, amount);
        if (CollUtil.isEmpty(dropItemList)) {
            return false;
        }
        PlayerSchedulerUtil.dropItem(player, dropItemList);
        MessageUtil.sendMessage(player, msg);
        return true;
    }

    private static List<ItemStack> addItemReturnDropItemMap(Player player, ItemStack itemStack, int amount) {
        PlayerInventory playerInventory = player.getInventory();
        ArrayList<ItemStack> dropItemList = new ArrayList<ItemStack>();
        int maxStackSize = itemStack.getMaxStackSize();
        if (amount > maxStackSize) {
            itemStack.setAmount(maxStackSize);
            dropItemList.addAll(playerInventory.addItem(new ItemStack[]{itemStack}).values());
            dropItemList.addAll(ItemStackUtil.addItemReturnDropItemMap(player, itemStack, amount - maxStackSize));
        } else {
            itemStack.setAmount(amount);
            dropItemList.addAll(playerInventory.addItem(new ItemStack[]{itemStack}).values());
        }
        return dropItemList;
    }

    public static Material getMaterial(String materialStr) {
        return ItemStackUtil.getMaterial(materialStr, Material.STONE);
    }

    public static Material getMaterial(String materialStr, Material defaultMaterial) {
        if (StrUtil.isEmpty(materialStr)) {
            return defaultMaterial;
        }
        Material material = Material.getMaterial((String)(materialStr = materialStr.toUpperCase(Locale.ROOT)));
        if (material != null) {
            return material;
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId() && (material = Material.getMaterial((String)("LEGACY_" + materialStr), (boolean)true)) != null) {
            return material;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId()) {
            return defaultMaterial;
        }
        return XMaterial.matchXMaterial(materialStr).orElse(XMaterial.matchXMaterial(defaultMaterial)).parseMaterial();
    }

    public static ItemStack getItemByMaterial(String materialStr) {
        return ItemStackUtil.getItemByMaterial(materialStr, Material.STONE);
    }

    public static ItemStack getItemByMaterial(String materialStr, Material defaultMaterial) {
        if (StrUtil.isEmpty(materialStr)) {
            return new ItemStack(defaultMaterial);
        }
        Material material = Material.getMaterial((String)(materialStr = materialStr.toUpperCase(Locale.ROOT)));
        if (material != null) {
            return new ItemStack(material);
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId() && (material = Material.getMaterial((String)("LEGACY_" + materialStr), (boolean)true)) != null) {
            return new ItemStack(material);
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId()) {
            return ItemStackUtil.getLegacyItemStack(materialStr, defaultMaterial);
        }
        return XMaterial.matchXMaterial(materialStr).orElse(XMaterial.matchXMaterial(defaultMaterial)).parseItem();
    }

    private static ItemStack getLegacyItemStack(String materialStr, Material defaultMaterial) {
        if (materialStr.contains(":")) {
            String[] parts = materialStr.split(":");
            Material material = Material.getMaterial((String)parts[0]);
            if (parts.length == 2 && material != null) {
                short data = (short)Integer.parseInt(parts[1]);
                return new ItemStack(material, 1, data);
            }
        }
        return new ItemStack(defaultMaterial);
    }

    public static ItemStack getItemInMainHand(PlayerInventory playerInventory) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            return playerInventory.getItemInHand();
        }
        return playerInventory.getItemInMainHand();
    }

    public static void setItemInMainHand(PlayerInventory playerInventory, ItemStack itemStack) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            playerInventory.setItemInHand(itemStack);
            return;
        }
        playerInventory.setItemInMainHand(itemStack);
    }

    public static ItemMeta getItemMeta(ItemStack itemStack) {
        ItemMeta itemMeta;
        if (itemStack == null) {
            itemStack = new ItemStack(Material.STONE);
        }
        if ((itemMeta = itemStack.getItemMeta()) == null) {
            return new ItemStack(Material.STONE).getItemMeta();
        }
        return itemMeta;
    }

    public static List<String> loreReplaceMap(List<String> loreList, Map<String, String> replaceMap) {
        ArrayList<String> newLoreList = new ArrayList<String>();
        if (replaceMap != null && !replaceMap.isEmpty() && CollUtil.isNotEmpty(loreList)) {
            for (String lore : loreList) {
                for (String key : replaceMap.keySet()) {
                    if (!lore.contains("${" + key + "}") || replaceMap.get(key) == null) continue;
                    lore = StrUtil.replace(lore, key, replaceMap.get(key));
                }
                newLoreList.add(lore);
            }
        } else {
            newLoreList.addAll(loreList);
        }
        return newLoreList;
    }

    public static List<String> loreBatchReplaceMap(List<String> loreList, Map<String, List<String>> replaceMap, String def) {
        if (CollUtil.isEmpty(loreList) || replaceMap == null || replaceMap.isEmpty()) {
            return loreList;
        }
        ArrayList<String> newLoreList = new ArrayList<String>();
        for (String lore : loreList) {
            newLoreList.addAll(ItemStackUtil.loreBatchReplaceMap(lore, replaceMap, def));
        }
        return newLoreList;
    }

    public static List<String> loreBatchReplaceMap(String lore, Map<String, List<String>> replaceMap, String def) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (StrUtil.isEmpty(lore)) {
            loreList.add(lore);
            return loreList;
        }
        if (replaceMap == null || replaceMap.isEmpty()) {
            loreList.add(lore);
            return loreList;
        }
        if (StrUtil.isEmpty(def)) {
            def = "";
        }
        for (String key : replaceMap.keySet()) {
            if (!lore.contains("${" + key + "}")) continue;
            List<String> replaceList = replaceMap.get(key);
            if (CollUtil.isEmpty(replaceList)) {
                loreList.add(StrUtil.replace(lore, key, def));
                break;
            }
            for (String replaceStr : replaceList) {
                loreList.add(StrUtil.replace(lore, key, replaceStr));
            }
        }
        if (CollUtil.isEmpty(loreList)) {
            loreList.add(lore);
        }
        return loreList;
    }

    public static void setPersistentData(ItemStack itemStack, String customData, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMetaUtil.setPersistentData(itemMeta, customData, key);
        itemStack.setItemMeta(itemMeta);
    }

    public static Optional<String> getPersistentData(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        return ItemMetaUtil.getPersistentData(itemMeta, key);
    }

    public static boolean isSimilar(ItemStack one, ItemStack two) {
        ItemMeta twoItemMeta;
        ItemMeta oneItemMeta;
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (!one.getType().equals((Object)two.getType())) {
            return false;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_13.getVersionId()) {
            MaterialData oneData = one.getData();
            MaterialData twoData = two.getData();
            if (oneData != null && twoData != null && oneData.getData() != twoData.getData()) {
                return false;
            }
        }
        if ((oneItemMeta = one.getItemMeta()) == (twoItemMeta = two.getItemMeta())) {
            return true;
        }
        if (oneItemMeta == null || twoItemMeta == null) {
            return false;
        }
        if (!StrUtil.equals(oneItemMeta.getDisplayName(), twoItemMeta.getDisplayName())) {
            return false;
        }
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId() && oneItemMeta.hasItemName() && twoItemMeta.hasItemName() && !StrUtil.equals(oneItemMeta.getItemName(), twoItemMeta.getItemName())) {
            return false;
        }
        return CollUtil.equals(oneItemMeta.getLore(), twoItemMeta.getLore());
    }

    public static void setOwner(ItemStack itemStack, String playerName) {
        if (itemStack == null || StrUtil.isEmpty(playerName)) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        ItemMetaUtil.setOwner(skullMeta, playerName);
        itemStack.setItemMeta((ItemMeta)skullMeta);
    }

    public static void setSkull(ItemStack itemStack, String base64) {
        if (itemStack == null || StrUtil.isEmpty(base64)) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        ItemMetaUtil.setSkull(skullMeta, base64);
        itemStack.setItemMeta((ItemMeta)skullMeta);
    }
}

