/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.util;

import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.constants.VersionCheckEnum;
import cn.handyplus.intensify.lib.util.MessageUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public final class LegacyUtil {
    private static Class<?> SOUND_CLASS;
    private static Class<?> ATTRIBUTE_CLASS;
    private static Class<?> BIOME_CLASS;

    private LegacyUtil() {
    }

    public static void setMaxHealth(@NotNull Player player, double maxHealth) {
        player.setMaxHealth(maxHealth);
    }

    public static double getMaxHealth(@NotNull Player player) {
        return player.getMaxHealth();
    }

    public static void setGameRuleValue(@NotNull World world, @NotNull String ruleName, @NotNull Object value) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            GameRule gameRule = GameRule.getByName((String)ruleName);
            if (gameRule == null) {
                MessageUtil.sendConsoleMessage("\u4e16\u754c\u89c4\u5219: " + ruleName + " \u4e0d\u5b58\u5728.");
                return;
            }
            if (value instanceof Boolean) {
                world.setGameRule(gameRule, (Object)((Boolean)value));
                return;
            }
            if (value instanceof Integer) {
                world.setGameRule(gameRule, (Object)((Integer)value));
                return;
            }
        }
        world.setGameRuleValue(ruleName, String.valueOf(value));
    }

    public static Enchantment getDurability() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.UNBREAKING;
        }
        return LegacyUtil.getEnchantmentByName("DURABILITY");
    }

    public static Enchantment getArrowDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.POWER;
        }
        return LegacyUtil.getEnchantmentByName("ARROW_DAMAGE");
    }

    public static Particle getFirework() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.FIREWORK;
        }
        return Particle.valueOf((String)"FIREWORKS_SPARK");
    }

    public static Particle getDripLava() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DRIPPING_LAVA;
        }
        return Particle.valueOf((String)"DRIP_LAVA");
    }

    public static Particle getRedStone() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DUST;
        }
        return Particle.valueOf((String)"REDSTONE");
    }

    public static Enchantment getEnchantmentByName(@NotNull String name) {
        return Enchantment.getByName((String)name);
    }

    public static String getEnchantmentName(@NotNull Enchantment enchantment) {
        return enchantment.getName();
    }

    public static String getEnchantmentKey(@NotNull Enchantment enchantment) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            return enchantment.getKey().getKey();
        }
        return null;
    }

    public static String getEntityTypeName(@NotNull EntityType entityType) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return entityType.getKey().getKey();
        }
        return entityType.getName();
    }

    public static List<String> getEntityTypeList() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return Arrays.stream(EntityType.values()).filter(e -> e != EntityType.UNKNOWN).map(e -> e.getKey().getKey()).collect(Collectors.toList());
        }
        return Arrays.stream(EntityType.values()).map(EntityType::getName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<String> getEntityTypeAliveList() {
        ArrayList<String> entityTypeList = new ArrayList<String>();
        boolean versionRst = BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId();
        for (EntityType type : EntityType.values()) {
            if (!type.isAlive() || !type.isSpawnable()) continue;
            if (versionRst) {
                entityTypeList.add(type.getKey().getKey());
                continue;
            }
            entityTypeList.add(type.getName());
        }
        return entityTypeList;
    }

    public static List<String> getEnchantmentList() {
        return Arrays.stream(Enchantment.values()).map(Enchantment::getName).collect(Collectors.toList());
    }

    public static PotionEffectType getIncreaseDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return PotionEffectType.getByName((String)"strength");
        }
        return PotionEffectType.getByName((String)"increase_damage");
    }

    public static EntityType getEntityTypeByName(@NotNull String name) {
        return EntityType.fromName((String)name);
    }

    public static PotionEffectType getPotionEffectTypeByName(@NotNull String name) {
        return PotionEffectType.getByName((String)name);
    }

    public static List<String> getPotionEffectTypeList() {
        return Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName).collect(Collectors.toList());
    }

    public static AttributeModifier getAttributeModifier(@NotNull String name, double amount, @NotNull AttributeModifier.Operation operation, @NotNull EquipmentSlot slot) {
        UUID uuid = UUID.randomUUID();
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21.getVersionId()) {
            return new AttributeModifier(uuid, name, amount, operation, slot);
        }
        return new AttributeModifier(NamespacedKey.fromString((String)uuid.toString()), amount, operation, slot.getGroup());
    }

    public static void initClasses() {
        try {
            SOUND_CLASS = Class.forName("org.bukkit.Sound");
            ATTRIBUTE_CLASS = BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_9.getVersionId() ? Class.forName("org.bukkit.attribute.Attribute") : null;
            BIOME_CLASS = Class.forName("org.bukkit.block.Biome");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u7c7b", e);
        }
    }

    public static Sound getSound(@NotNull String sound) throws Exception {
        if (SOUND_CLASS.isEnum()) {
            Enum t = Enum.valueOf(SOUND_CLASS.asSubclass(Enum.class), sound.toUpperCase());
            return (Sound)t;
        }
        Method getMethod = SOUND_CLASS.getMethod("valueOf", String.class);
        return (Sound)getMethod.invoke(null, sound.toUpperCase());
    }

    public static Biome getBiome(@NotNull String name) throws Exception {
        if (BIOME_CLASS.isEnum()) {
            Enum t = Enum.valueOf(BIOME_CLASS.asSubclass(Enum.class), name);
            return (Biome)t;
        }
        Method getMethod = BIOME_CLASS.getMethod("valueOf", String.class);
        return (Biome)getMethod.invoke(null, name);
    }

    public static Attribute getAttribute(@NotNull String name) {
        if (ATTRIBUTE_CLASS == null) {
            return null;
        }
        if (ATTRIBUTE_CLASS.isEnum()) {
            try {
                Enum t = Enum.valueOf(ATTRIBUTE_CLASS.asSubclass(Enum.class), name);
                return (Attribute)t;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u7684\u5c5e\u6027: " + name, e);
            }
        }
        try {
            Method getMethod = ATTRIBUTE_CLASS.getMethod("valueOf", String.class);
            return (Attribute)getMethod.invoke(null, name);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5c5e\u6027: " + name, e);
        }
    }
}

