/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.util;

import cn.handyplus.intensify.lib.InitApi;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.constants.VersionCheckEnum;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.RgbTextUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class MessageUtil {
    private MessageUtil() {
    }

    public static void sendMessage(UUID playerUuid, String msg) {
        Optional<Player> playerOpt = BaseUtil.getOnlinePlayer(playerUuid);
        playerOpt.ifPresent(player -> MessageUtil.sendMessage(player, msg));
    }

    public static void sendMessage(String playerName, String msg) {
        Optional<Player> playerOpt = BaseUtil.getOnlinePlayer(playerName);
        playerOpt.ifPresent(player -> MessageUtil.sendMessage(player, msg));
    }

    public static void sendMessage(Player player, String msg) {
        MessageUtil.sendMessage(true, player, msg);
    }

    public static void sendMessage(boolean rst, Player player, String msg) {
        if (!rst || StrUtil.isEmpty(msg)) {
            return;
        }
        player.sendMessage(BaseUtil.replaceChatColor(msg));
    }

    public static void sendDebugMessage(Player player, String msg) {
        if (BaseConstants.DEBUG) {
            MessageUtil.sendMessage(player, msg);
        }
    }

    public static void sendMessage(Player player, TextComponent msg) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            player.spigot().sendMessage((BaseComponent)msg);
            return;
        }
        player.spigot().sendMessage(ChatMessageType.CHAT, (BaseComponent)msg);
    }

    public static void sendMessage(Player player, BaseComponent[] msg) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            player.spigot().sendMessage(msg);
            return;
        }
        player.spigot().sendMessage(ChatMessageType.CHAT, msg);
    }

    public static void sendDebugMessage(Player player, TextComponent msg) {
        if (BaseConstants.DEBUG) {
            MessageUtil.sendMessage(player, msg);
        }
    }

    public static void sendWarnMessage(CommandSender sender, String msg) {
        if (BaseConstants.WARN) {
            MessageUtil.sendMessage(sender, msg);
        }
    }

    public static void sendDebugMessage(CommandSender sender, String msg) {
        if (BaseConstants.DEBUG) {
            MessageUtil.sendMessage(sender, msg);
        }
    }

    public static void sendMessage(List<String> playerNameList, TextComponent msg) {
        if (CollUtil.isEmpty(playerNameList)) {
            return;
        }
        for (String playerName : playerNameList) {
            Optional<Player> playerOpt = BaseUtil.getOnlinePlayer(playerName);
            playerOpt.ifPresent(player -> MessageUtil.sendMessage(player, msg));
        }
    }

    public static void sendMessage(List<UUID> playerUuidList, BaseComponent[] msg) {
        if (CollUtil.isEmpty(playerUuidList)) {
            return;
        }
        for (UUID playerUuid : playerUuidList) {
            Optional<Player> playerOpt = BaseUtil.getOnlinePlayer(playerUuid);
            playerOpt.ifPresent(player -> MessageUtil.sendMessage(player, msg));
        }
    }

    public static void sendMessage(CommandSender sender, String msg) {
        if (StrUtil.isEmpty(msg) || sender == null) {
            return;
        }
        sender.sendMessage(BaseUtil.replaceChatColor(msg));
    }

    public static void sendAllMessage(String msg) {
        if (StrUtil.isEmpty(msg)) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageUtil.sendMessage(player, msg);
        }
    }

    public static void sendAllMessage(List<String> msgList) {
        if (CollUtil.isEmpty(msgList)) {
            return;
        }
        for (String msg : msgList) {
            MessageUtil.sendAllMessage(msg);
        }
    }

    public static void sendAllMessage(BaseComponent[] msg) {
        if (msg == null) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageUtil.sendMessage(player, msg);
        }
    }

    public static void sendAllMessage(TextComponent msg) {
        if (msg == null) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageUtil.sendMessage(player, msg);
        }
    }

    public static void sendConsoleMessage(String msg) {
        MessageUtil.sendConsoleMessage(true, msg);
    }

    public static void sendConsoleMessage(boolean rst, String msg) {
        if (!rst || StrUtil.isEmpty(msg)) {
            return;
        }
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "[" + InitApi.PLUGIN.getName() + "] " + BaseUtil.replaceChatColor(msg));
    }

    public static void sendConsoleMessage(List<String> msgList) {
        if (CollUtil.isEmpty(msgList)) {
            return;
        }
        for (String msg : msgList) {
            MessageUtil.sendConsoleMessage(msg);
        }
    }

    public static void sendConsoleWarnMessage(String msg) {
        if (BaseConstants.WARN) {
            MessageUtil.sendConsoleMessage(msg);
        }
    }

    public static void sendConsoleDebugMessage(String msg) {
        if (BaseConstants.DEBUG) {
            MessageUtil.sendConsoleMessage(msg);
        }
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadein, int stay, int fadeout) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_8_8.getVersionId() && BaseConstants.VERSION_ID < VersionCheckEnum.V_1_11.getVersionId()) {
            player.sendTitle(BaseUtil.replaceChatColor(title), BaseUtil.replaceChatColor(subtitle));
            return;
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_10.getVersionId()) {
            player.sendTitle(BaseUtil.replaceChatColor(title), BaseUtil.replaceChatColor(subtitle), fadein, stay, fadeout);
        }
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            MessageUtil.sendMessage(player, BaseUtil.replaceChatColor(title + subtitle));
            return;
        }
        player.sendTitle(BaseUtil.replaceChatColor(title), BaseUtil.replaceChatColor(subtitle));
    }

    public static void sendAllTitle(String title, String subtitle, int fadein, int stay, int fadeout) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageUtil.sendTitle(player, title, subtitle, fadein, stay, fadeout);
        }
    }

    public static void sendAllTitle(String title, String subtitle) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageUtil.sendTitle(player, title, subtitle);
        }
    }

    public static void sendActionbar(Player player, String msg) {
        if (StrUtil.isEmpty(msg)) {
            return;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            MessageUtil.sendMessage(player, msg);
            return;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, RgbTextUtil.getInstance().init(msg).build());
    }

    public static void sendAllActionbar(String msg) {
        if (StrUtil.isEmpty(msg)) {
            return;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            MessageUtil.sendAllMessage(msg);
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, RgbTextUtil.getInstance().init(msg).build());
        }
    }
}

