/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.listener;

import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.lib.annotation.HandyListener;
import cn.handyplus.intensify.lib.core.MapUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.LotteryUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.Map;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class BlockBreakEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled() || !event.isDropItems()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        LotteryUtil lotteryUtil = IntensifyConstants.BLOCK_LOTTERY_MAP.get(block.getType().name());
        if (lotteryUtil == null || lotteryUtil.randomIndex() != 0) {
            return;
        }
        ItemStack itemInHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        Map enchantments = itemInHand.getEnchantments();
        if (!enchantments.isEmpty()) {
            for (Enchantment enchantment : enchantments.keySet()) {
                if (!Enchantment.SILK_TOUCH.equals(enchantment)) continue;
                return;
            }
        }
        player.getWorld().dropItem(block.getLocation(), IntensifyUtil.getRyanCokes());
        String blockBreakMag = BaseUtil.getMsgNotColor("blockBreakMag", MapUtil.of("${name}", BaseUtil.getMsgNotColor("ryanCokes.name")));
        MessageUtil.sendMessage(player, blockBreakMag);
    }
}

