/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.listener;

import cn.handyplus.intensify.constants.CokesTypeEnum;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.event.PlayerIntensifyEvent;
import cn.handyplus.intensify.intensify.IntensifyStrategy;
import cn.handyplus.intensify.lib.annotation.HandyListener;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.JsonUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.inventory.HandyInventoryUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.lib.util.ProbabilityUtil;
import cn.handyplus.intensify.listener.FurnaceBurnEventListener;
import cn.handyplus.intensify.param.IntensifyCardParam;
import cn.handyplus.intensify.param.IntensifyResult;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class InventoryClickEventListener
implements Listener {
    @EventHandler
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Optional<Player> playerOptional = HandyInventoryUtil.getPlayer(event);
        if (!playerOptional.isPresent()) {
            return;
        }
        Player player = playerOptional.get();
        if (event.getRawSlot() < 1) {
            MessageUtil.sendDebugMessage(player, "\u4e0d\u662f \u6709\u6548\u683c\u5b50");
            return;
        }
        if (!event.getClick().isLeftClick()) {
            MessageUtil.sendDebugMessage(player, "\u4e0d\u662f \u5de6\u952e");
            return;
        }
        if (!InventoryAction.SWAP_WITH_CURSOR.equals((Object)event.getAction())) {
            MessageUtil.sendDebugMessage(player, "\u4e0d\u662f \u5149\u6807\u4e0a\u7684\u7269\u54c1\u4e0e\u6240\u5355\u51fb\u7684\u683c\u5b50\u4e2d\u7684\u7269\u54c1\u76f8\u4e92\u4ea4\u6362.");
            return;
        }
        ItemStack cursor = event.getCursor();
        Material material = ItemStackUtil.getMaterial(BaseUtil.getLangMsg("intensifyCard.material"), Material.PAPER);
        if (cursor == null || !material.equals((Object)cursor.getType()) || cursor.getItemMeta() == null || StrUtil.isEmpty(cursor.getItemMeta().getDisplayName()) || CollUtil.isEmpty(cursor.getItemMeta().getLore())) {
            MessageUtil.sendDebugMessage(player, "\u4e0d\u662f \u5f3a\u5316\u5238");
            return;
        }
        if (cursor.getAmount() != 1) {
            MessageUtil.sendDebugMessage(player, "\u5f3a\u5316\u5238\u6570\u91cf\u4e0d\u4e3a1");
            return;
        }
        Optional<String> persistentDataOpt = ItemStackUtil.getPersistentData(cursor, "card");
        if (!persistentDataOpt.isPresent()) {
            MessageUtil.sendDebugMessage(player, "\u4e0d\u662f \u5f3a\u5316\u5238\uff0c\u6ca1\u6709\u5f3a\u5316\u5c5e\u6027");
            return;
        }
        String persistentData = persistentDataOpt.get();
        IntensifyCardParam intensifyCardParam = JsonUtil.toBean(persistentData, IntensifyCardParam.class);
        Integer probability = intensifyCardParam.getProbability();
        Integer level = intensifyCardParam.getLevel();
        if (probability == null || level == null) {
            MessageUtil.sendDebugMessage(player, "\u4e0d\u662f \u5f3a\u5316\u5238\uff0c\u5f3a\u5316\u5c5e\u6027\u4e0d\u5168");
            return;
        }
        ItemStack itemStack = IntensifyUtil.getIntensifyCard(cursor.getItemMeta().getDisplayName(), probability, level);
        if (!ItemStackUtil.isSimilar(cursor, itemStack)) {
            MessageUtil.sendDebugMessage(player, "\u4e0d\u662f \u5f3a\u5316\u5238\uff0c\u65e0\u6cd5\u5339\u914d\u7684\u4e0a");
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        SwordEnum swordEnum = SwordEnum.getEnum(currentItem.getType());
        if (swordEnum == null) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("noIntensify"));
            return;
        }
        boolean check = FurnaceBurnEventListener.check(currentItem);
        if (!check) {
            return;
        }
        if (GameMode.CREATIVE.equals((Object)player.getGameMode())) {
            MessageUtil.sendMessage(player, "&e\u521b\u9020\u6a21\u5f0f\u65e0\u6cd5\u4f7f\u7528\u8be5\u7269\u54c1\u5f3a\u5316");
            return;
        }
        boolean pickIndex = ProbabilityUtil.getInstance().pickIndex(probability, 100);
        MessageUtil.sendDebugMessage(player, "\u672c\u6b21\u5f3a\u5316\u51e0\u7387:" + probability + ",\u7ed3\u679c:" + pickIndex);
        IntensifyResult intensifyResult = IntensifyStrategy.getInstance().intensify((OfflinePlayer)player, currentItem, CokesTypeEnum.RYAN_COKES, pickIndex, level, true);
        if (cursor.getAmount() > 1) {
            cursor.setAmount(cursor.getAmount() - 1);
        } else {
            event.setCursor(currentItem);
            event.setCurrentItem(new ItemStack(Material.AIR));
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerIntensifyEvent(intensifyResult));
    }
}

