/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.listener;

import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.lib.annotation.HandyListener;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.core.MapUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.LotteryUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class PlayerFishEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!PlayerFishEvent.State.CAUGHT_FISH.equals((Object)event.getState())) {
            return;
        }
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        Item item = (Item)event.getCaught();
        ItemStack fishItemStack = item.getItemStack();
        Player player = event.getPlayer();
        LotteryUtil lotteryUtil = IntensifyConstants.FISH_LOTTERY_MAP.get(fishItemStack.getType().name());
        if (lotteryUtil == null || lotteryUtil.randomIndex() != 0) {
            return;
        }
        Location location = player.getLocation();
        boolean isChunkLimit = BaseConstants.CONFIG.getBoolean("isChunkLimit", true);
        if (isChunkLimit) {
            Chunk chunk = location.getChunk();
            Set<Chunk> chunkSet = IntensifyConstants.CHUNK_SET;
            if (chunkSet.contains(location.getChunk())) {
                return;
            }
            IntensifyConstants.CHUNK_SET.add(chunk);
        }
        player.getWorld().dropItem(location, IntensifyUtil.getRyanCokes());
        String blockBreakMag = BaseUtil.getMsgNotColor("blockBreakMag", MapUtil.of("${name}", BaseUtil.getMsgNotColor("ryanCokes.name")));
        MessageUtil.sendMessage(player, blockBreakMag);
    }
}

