/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.listener;

import cn.handyplus.intensify.constants.IntensifyResultTypeEnum;
import cn.handyplus.intensify.entity.PlayerIntensifyEntity;
import cn.handyplus.intensify.event.PlayerIntensifyEvent;
import cn.handyplus.intensify.lib.annotation.HandyListener;
import cn.handyplus.intensify.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.intensify.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.param.IntensifyResult;
import cn.handyplus.intensify.service.PlayerIntensifyService;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@HandyListener
public class PlayerIntensifyEventListener
implements Listener {
    @EventHandler
    public void onPlayerIntensify(PlayerIntensifyEvent event) {
        IntensifyResult intensifyResult = event.getIntensifyResult();
        String displayName = IntensifyUtil.delIntensifyLevel(intensifyResult.getDisplayName()).trim() + " \u00a7f[+\u00a7a" + intensifyResult.getLevel() + "\u00a7f]";
        intensifyResult.setDisplayName(displayName);
        this.sendPlayerMsg(intensifyResult);
        IntensifyUtil.sendAllMsg(intensifyResult);
        this.saveOrUpdate(intensifyResult);
    }

    private void sendPlayerMsg(IntensifyResult intensifyResult) {
        Player player = intensifyResult.getPlayer();
        if (player == null || !player.isOnline()) {
            return;
        }
        String displayName = intensifyResult.getDisplayName();
        switch (intensifyResult.getResult()) {
            case SUCCESS: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifySucceedMsg").replace("${displayName}", displayName));
                break;
            }
            case FAILED_DOWNGRADED: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifyFailureLevelOffMsg").replace("${displayName}", displayName));
                break;
            }
            case FAILED_DISAPPEARED: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifyFailureMsg").replace("${displayName}", displayName));
                break;
            }
            case LIMIT: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifyTopMsg"));
                break;
            }
            case FAILED_PROTECTION_CARD: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifyProtectionCardMsg").replace("${displayName}", displayName));
                break;
            }
            case FAILED_NO_CHANGE: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifyCardFailureMsg").replace("${displayName}", displayName));
                break;
            }
            case FAILED: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifyFailureTwoMsg", "&c\u5f3a\u5316 &f${displayName} &c\u5931\u8d25").replace("${displayName}", displayName));
                break;
            }
            case FAILED_PROTECTION_AMULET: {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("intensifyProtectionAmuletMsg").replace("${displayName}", displayName));
                break;
            }
        }
        PlayerSchedulerUtil.playSound(player, Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
    }

    private void saveOrUpdate(IntensifyResult intensifyResult) {
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            OfflinePlayer offlinePlayer = intensifyResult.getOfflinePlayer();
            Optional<PlayerIntensifyEntity> playerIntensifyEntityOptional = PlayerIntensifyService.getInstance().findByPlayerUuid(offlinePlayer.getUniqueId().toString());
            if (!playerIntensifyEntityOptional.isPresent()) {
                PlayerIntensifyEntity playerIntensifyEntity = new PlayerIntensifyEntity();
                playerIntensifyEntity.setSucceedNum(0);
                playerIntensifyEntity.setTenNum(0);
                playerIntensifyEntity.setFailureNum(0);
                playerIntensifyEntity.setLevelOffNum(0);
                playerIntensifyEntity.setVanishNum(0);
                playerIntensifyEntity.setMaxLevel(0);
                playerIntensifyEntity.setPlayerName(offlinePlayer.getName());
                playerIntensifyEntity.setPlayerUuid(offlinePlayer.getUniqueId().toString());
                playerIntensifyEntity.setSum(1);
                if (IntensifyResultTypeEnum.SUCCESS.equals((Object)intensifyResult.getResult())) {
                    playerIntensifyEntity.setSucceedNum(1);
                    playerIntensifyEntity.setMaxLevel(intensifyResult.getLevel());
                    playerIntensifyEntity.setMaxLevelName(intensifyResult.getDisplayName());
                    playerIntensifyEntity.setMaterialName(intensifyResult.getMaterialName());
                    if (intensifyResult.getLevel() >= 10) {
                        playerIntensifyEntity.setTenNum(1);
                    }
                } else {
                    playerIntensifyEntity.setFailureNum(1);
                    if (IntensifyResultTypeEnum.FAILED_DOWNGRADED.equals((Object)intensifyResult.getResult())) {
                        playerIntensifyEntity.setLevelOffNum(1);
                    }
                    if (IntensifyResultTypeEnum.FAILED_DISAPPEARED.equals((Object)intensifyResult.getResult())) {
                        playerIntensifyEntity.setVanishNum(1);
                    }
                }
                PlayerIntensifyService.getInstance().add(playerIntensifyEntity);
                return;
            }
            PlayerIntensifyEntity playerIntensifyEntity = playerIntensifyEntityOptional.get();
            playerIntensifyEntity.setPlayerName(offlinePlayer.getName());
            playerIntensifyEntity.setSum(playerIntensifyEntity.getSum() + 1);
            if (IntensifyResultTypeEnum.SUCCESS.equals((Object)intensifyResult.getResult())) {
                playerIntensifyEntity.setSucceedNum(playerIntensifyEntity.getSucceedNum() + 1);
                if (intensifyResult.getLevel() > playerIntensifyEntity.getMaxLevel()) {
                    playerIntensifyEntity.setMaxLevel(intensifyResult.getLevel());
                    playerIntensifyEntity.setMaxLevelName(intensifyResult.getDisplayName());
                    playerIntensifyEntity.setMaterialName(intensifyResult.getMaterialName());
                }
                if (intensifyResult.getLevel() >= 10) {
                    playerIntensifyEntity.setTenNum(playerIntensifyEntity.getTenNum() + 1);
                }
            } else {
                playerIntensifyEntity.setFailureNum(playerIntensifyEntity.getFailureNum() + 1);
                if (IntensifyResultTypeEnum.FAILED_DOWNGRADED.equals((Object)intensifyResult.getResult())) {
                    playerIntensifyEntity.setLevelOffNum(playerIntensifyEntity.getLevelOffNum() + 1);
                }
                if (IntensifyResultTypeEnum.FAILED_DISAPPEARED.equals((Object)intensifyResult.getResult())) {
                    playerIntensifyEntity.setVanishNum(playerIntensifyEntity.getVanishNum() + 1);
                }
            }
            PlayerIntensifyService.getInstance().update(playerIntensifyEntity);
        });
    }
}

