/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.service;

import cn.handyplus.intensify.entity.PlayerIntensifyEntity;
import cn.handyplus.intensify.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class PlayerIntensifyService {
    private static final PlayerIntensifyService INSTANCE = new PlayerIntensifyService();

    private PlayerIntensifyService() {
    }

    public static PlayerIntensifyService getInstance() {
        return INSTANCE;
    }

    public Boolean add(PlayerIntensifyEntity entity) {
        return Db.use(PlayerIntensifyEntity.class).execution().insert(entity) > 0;
    }

    public Optional<PlayerIntensifyEntity> findByPlayerUuid(String playerUuid) {
        Db<PlayerIntensifyEntity> use = Db.use(PlayerIntensifyEntity.class);
        use.where().eq(PlayerIntensifyEntity::getPlayerUuid, playerUuid);
        return use.execution().selectOne();
    }

    public List<PlayerIntensifyEntity> findRanking() {
        Db<PlayerIntensifyEntity> use = Db.use(PlayerIntensifyEntity.class);
        use.where().orderByDesc(PlayerIntensifyEntity::getSum).limit(1, 10);
        return use.execution().page().getRecords();
    }

    public void update(PlayerIntensifyEntity entity) {
        Db<PlayerIntensifyEntity> use = Db.use(PlayerIntensifyEntity.class);
        use.update().set(entity.getSum() != null, PlayerIntensifyEntity::getSum, entity.getSum()).set(entity.getSucceedNum() != null, PlayerIntensifyEntity::getSucceedNum, entity.getSucceedNum()).set(entity.getTenNum() != null, PlayerIntensifyEntity::getTenNum, entity.getTenNum()).set(entity.getFailureNum() != null, PlayerIntensifyEntity::getFailureNum, entity.getFailureNum()).set(entity.getLevelOffNum() != null, PlayerIntensifyEntity::getLevelOffNum, entity.getLevelOffNum()).set(entity.getVanishNum() != null, PlayerIntensifyEntity::getVanishNum, entity.getVanishNum()).set(entity.getMaxLevel() != null, PlayerIntensifyEntity::getMaxLevel, entity.getMaxLevel()).set(entity.getMaxLevelName() != null, PlayerIntensifyEntity::getMaxLevelName, entity.getMaxLevelName()).set(entity.getMaterialName() != null, PlayerIntensifyEntity::getMaterialName, entity.getMaterialName()).set(entity.getPlayerName() != null, PlayerIntensifyEntity::getPlayerName, entity.getPlayerName());
        use.execution().updateById(entity.getId());
    }

    public List<PlayerIntensifyEntity> findAll() {
        return Db.use(PlayerIntensifyEntity.class).execution().list();
    }
}

