/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.crawl.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.ToggleKeyMapping;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrawlClient {
    private static final Path CONFIG_PATH = Path.of("./config/crawl.properties", new String[0]);
    private static final Logger LOGGER = LogManager.getLogger((String)"CrawlClient");
    public static final OptionInstance<Boolean> crawlToggled;
    public static final KeyMapping key;
    public static boolean replaceAnimation;

    public static void saveOptions() {
        try {
            CrawlClient.createProps().store(Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), null);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't save config", (Throwable)e);
        }
    }

    private static Properties createProps() {
        Properties props = new Properties();
        props.setProperty("replace-crawl-animation", Boolean.toString(replaceAnimation));
        return props;
    }

    static {
        replaceAnimation = true;
        crawlToggled = new OptionInstance("key.crawl", OptionInstance.noTooltip(), (optionText, value) -> value != false ? Options.MOVEMENT_TOGGLE : Options.MOVEMENT_HOLD, (OptionInstance.ValueSet)OptionInstance.BOOLEAN_VALUES, (Object)false, value -> {});
        key = new ToggleKeyMapping("key.crawl", -1, "key.categories.movement", () -> crawlToggled.get());
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Properties props = CrawlClient.createProps();
            try {
                props.load(Files.newInputStream(CONFIG_PATH, new OpenOption[0]));
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't load config", (Throwable)e);
            }
            replaceAnimation = Boolean.parseBoolean(props.getProperty("replace-crawl-animation"));
        } else {
            CrawlClient.saveOptions();
        }
    }
}

