/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.crawl.mixin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.fewizz.crawl.Crawl;
import ru.fewizz.crawl.PlayerExtended;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerExtended {
    @Shadow
    @Final
    private Abilities abilities;
    @Shadow
    @Final
    @Mutable
    private static Map<Pose, EntityDimensions> POSES;
    @Unique
    Pose crawl_prevPose;
    @Unique
    Pose crawl_prevTickPose;
    @Unique
    boolean crawl_requested;

    PlayerMixin() {
        super(null, null);
    }

    @Override
    public boolean wasPreviouslyCrawling() {
        return this.crawl_prevPose == Crawl.Shared.CRAWLING || this.crawl_prevTickPose == Crawl.Shared.CRAWLING;
    }

    @Override
    public boolean getRequestedCrawling() {
        return this.crawl_requested;
    }

    @Override
    public void setRequestedCrawling(boolean value) {
        this.crawl_requested = value;
    }

    @ModifyArg(method={"updatePlayerPose"}, at=@At(value="INVOKE", target="net/minecraft/world/entity/player/Player.setPose(Lnet/minecraft/world/entity/Pose;)V"))
    private Pose onPreUpdatePlayerPose(Pose pose) {
        if (!(this.isSpectator() || this.isPassenger() || this.abilities.flying)) {
            boolean swimming;
            boolean bl = swimming = this.isSwimming() || this.isInWater();
            if (this.crawl_requested) {
                pose = swimming ? Pose.SWIMMING : Crawl.Shared.CRAWLING;
            } else if (pose == Pose.SWIMMING && !swimming) {
                pose = Crawl.Shared.CRAWLING;
            }
        }
        return pose;
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void onPoseMapCreation(CallbackInfo ci) {
        POSES = ImmutableMap.builder().putAll(POSES).put((Object)Crawl.Shared.CRAWLING, (Object)Crawl.Shared.CRAWLING_DIMENSIONS).build();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTickEnd(CallbackInfo ci) {
        Pose newPose = this.getPose();
        if (newPose != this.crawl_prevTickPose) {
            this.crawl_prevPose = this.crawl_prevTickPose;
        }
        this.crawl_prevTickPose = newPose;
    }
}

