/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.crawl;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import ru.fewizz.crawl.PlayerExtended;

public class Crawl {
    public static Consumer<Boolean> sendCrawlRequestPacketToServer = null;

    public static void onCrawlRequestFromClient(Player serverPlayer, boolean value) {
        serverPlayer.getServer().execute(() -> ((PlayerExtended)serverPlayer).setRequestedCrawling(value));
    }

    public static class Shared {
        public static final Pose CRAWLING = Pose.valueOf((String)"CRAWLING");
        public static final EntityDimensions CRAWLING_DIMENSIONS = EntityDimensions.scalable((float)0.6f, (float)0.6f).withEyeHeight(0.5f);
    }

    public record Request(boolean crawl) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Request> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"crawl:request"));
        public static final StreamCodec<ByteBuf, Request> CODEC = ByteBufCodecs.BOOL.map(Request::new, Request::crawl);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

