/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.crawl.client.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.fewizz.crawl.Crawl;
import ru.fewizz.crawl.PlayerExtended;
import ru.fewizz.crawl.client.CrawlClient;

@Mixin(value={LocalPlayer.class})
abstract class LocalPlayerMixin
extends AbstractClientPlayer {
    @Shadow
    public ClientInput input;
    @Shadow
    protected int sprintTriggerTime;

    LocalPlayerMixin() {
        super(null, null);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    public void aiStep(CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player.getPose() == Crawl.Shared.CRAWLING) {
            this.sprintTriggerTime = 0;
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="net/minecraft/client/player/AbstractClientPlayer.aiStep()V")})
    public void beforeSuperAiStep(CallbackInfo ci) {
        PlayerExtended pe;
        boolean wantsToCrawl = CrawlClient.key.isDown();
        if (wantsToCrawl != (pe = (PlayerExtended)((Object)this)).getRequestedCrawling()) {
            Crawl.sendCrawlRequestPacketToServer.accept(wantsToCrawl);
            pe.setRequestedCrawling(wantsToCrawl);
        }
        if (this.getPose() == Crawl.Shared.CRAWLING) {
            this.setSprinting(false);
        }
    }
}

