/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import tallestegg.guardvillagers.GuardMemoryTypes;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.ai.tasks.VillagerHelp;

public class RepairGolem
extends VillagerHelp {
    private LivingEntity golem;

    public RepairGolem() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_148204_, (Object)MemoryStatus.VALUE_PRESENT), (List)GuardConfig.COMMON.professionsThatRepairGolems.get());
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, Villager owner) {
        List list = (List)owner.m_6274_().m_21952_(MemoryModuleType.f_148204_).get();
        if (!list.isEmpty()) {
            for (LivingEntity golem : list) {
                if (golem.m_20145_() || !golem.m_6084_() || golem.m_6095_() != EntityType.f_20460_ || !(golem.m_21223_() <= golem.m_21233_() * 0.75f)) continue;
                this.golem = golem;
                return super.checkExtraStartConditions(worldIn, owner);
            }
        }
        return false;
    }

    @Override
    protected long timeToCheck(LivingEntity owner) {
        Optional optional = owner.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.LAST_REPAIRED_GOLEM.get());
        return optional.isPresent() ? (Long)optional.get() : 0L;
    }

    protected boolean canStillUse(ServerLevel level, Villager entity, long gameTime) {
        return (Integer)entity.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.TIMES_HEALED_GOLEM.get()).orElse(null) < (Integer)GuardConfig.COMMON.maxGolemRepair.get() && this.golem.m_21223_() <= this.golem.m_21233_();
    }

    protected void stop(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if ((Integer)entityIn.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.TIMES_HEALED_GOLEM.get()).orElse(null) >= (Integer)GuardConfig.COMMON.maxGolemRepair.get()) {
            entityIn.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            entityIn.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.LAST_REPAIRED_GOLEM.get(), (Object)worldIn.m_46468_());
            entityIn.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            entityIn.m_6274_().m_21936_(MemoryModuleType.f_26371_);
            entityIn.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.TIMES_HEALED_GOLEM.get(), (Object)0);
        }
    }

    protected void start(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (this.golem == null) {
            return;
        }
        if (!entityIn.m_6274_().m_21874_((MemoryModuleType)GuardMemoryTypes.TIMES_HEALED_GOLEM.get())) {
            entityIn.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.TIMES_HEALED_GOLEM.get(), (Object)0);
        }
    }

    protected void tick(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        this.healGolem(entityIn);
    }

    public void healGolem(Villager healer) {
        BehaviorUtils.m_22590_((LivingEntity)healer, (Entity)this.golem, (float)0.5f, (int)0);
        if ((double)healer.m_20270_((Entity)this.golem) <= 2.0) {
            healer.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.TIMES_HEALED_GOLEM.get(), (Object)((Integer)healer.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.TIMES_HEALED_GOLEM.get()).orElse(null) + 1));
            healer.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42416_));
            healer.m_6674_(InteractionHand.MAIN_HAND);
            this.golem.m_5634_(15.0f);
            float pitch = 1.0f + (this.golem.m_217043_().m_188501_() - this.golem.m_217043_().m_188501_()) * 0.2f;
            this.golem.m_5496_(SoundEvents.f_12009_, 1.0f, pitch);
        }
    }
}

