/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.GuardLootTables;
import tallestegg.guardvillagers.GuardMemoryTypes;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.GuardStats;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;

@Mod(value="guardvillagers")
public class GuardVillagers {
    public static final String MODID = "guardvillagers";

    public GuardVillagers() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)GuardConfig.COMMON_SPEC);
        GuardConfig.loadConfig(GuardConfig.COMMON_SPEC, FMLPaths.CONFIGDIR.get().resolve("guardvillagers-common.toml").toString());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)GuardConfig.CLIENT_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GuardEntityType.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        GuardItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        GuardSounds.SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        GuardStats.STATS.register(FMLJavaModLoadingContext.get().getModEventBus());
        GuardMemoryTypes.MEMORY_MODULE_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        GuardLootTables.LOOT_ITEM_FUNCTION_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addCreativeTabs);
        GuardPacketHandler.registerPackets();
    }

    public static boolean hotvChecker(Player player, Guard guard) {
        return player.m_21023_(MobEffects.f_19595_) && GuardConfig.giveGuardStuffHOTV || !GuardConfig.giveGuardStuffHOTV || guard.getPlayerReputation(player) > GuardConfig.reputationRequirement && !player.m_9236_().m_5776_();
    }

    private void addCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.m_246326_((ItemLike)GuardItems.GUARD_SPAWN_EGG.get());
            event.m_246326_((ItemLike)GuardItems.ILLUSIONER_SPAWN_EGG.get());
        }
    }

    public static boolean canFollow(Player player) {
        return (Boolean)GuardConfig.COMMON.followHero.get() != false && player.m_21023_(MobEffects.f_19595_) || (Boolean)GuardConfig.COMMON.followHero.get() == false;
    }

    private void setup(FMLCommonSetupEvent event) {
        Stats.f_12988_.m_12899_((Object)((ResourceLocation)GuardStats.GUARDS_MADE.get()), StatFormatter.f_12873_);
        if (GuardConfig.IllusionerRaids) {
            Raid.RaiderType.create((String)"thebluemengroup", (EntityType)EntityType.f_20459_, (int[])new int[]{0, 0, 0, 0, 0, 1, 1, 2});
        }
    }

    private void addAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GuardEntityType.GUARD.get(), Guard.createAttributes().m_22265_());
    }

    public static String removeModIdFromVillagerType(String stringWithModId) {
        String[] parts = stringWithModId.split(":");
        if (parts.length <= 1) {
            return parts[0];
        }
        return parts[1];
    }
}

