/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import tallestegg.guardvillagers.GuardMemoryTypes;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.ai.tasks.VillagerHelp;

public class HealGuardAndHero
extends VillagerHelp {
    private LivingEntity targetToHeal;
    private int waitUntilInSightTicks = 0;

    public HealGuardAndHero() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_148204_, (Object)MemoryStatus.VALUE_PRESENT), (List)GuardConfig.COMMON.professionsThatHeal.get());
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, Villager owner) {
        List list = (List)owner.m_6274_().m_21952_(MemoryModuleType.f_148204_).get();
        if (!list.isEmpty()) {
            for (LivingEntity searchedForHeal : list) {
                if (!(searchedForHeal instanceof Guard) && !searchedForHeal.m_21023_(MobEffects.f_19595_) && !(searchedForHeal instanceof Villager) || !(searchedForHeal.m_21223_() < searchedForHeal.m_21233_()) || !((double)searchedForHeal.m_20270_((Entity)owner) <= 4.0)) continue;
                this.targetToHeal = searchedForHeal;
                return super.checkExtraStartConditions(level, owner);
            }
        }
        return false;
    }

    @Override
    protected long timeToCheck(LivingEntity owner) {
        Optional optional = owner.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.LAST_THROWN_POTION.get());
        return optional.isPresent() ? (Long)optional.get() : 0L;
    }

    protected boolean canStillUse(ServerLevel level, Villager entity, long gameTime) {
        return this.checkIfDayHavePassedFromLastActivity((LivingEntity)entity) && (Integer)entity.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get()).orElse(null) < (Integer)GuardConfig.COMMON.maxClericHeal.get();
    }

    protected void tick(ServerLevel level, Villager owner, long gameTime) {
        super.m_6725_(level, (LivingEntity)owner, gameTime);
        BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)this.targetToHeal);
        owner.m_21391_((Entity)this.targetToHeal, 30.0f, 30.0f);
        owner.m_21563_().m_148051_((Entity)this.targetToHeal);
        this.waitUntilInSightTicks = !owner.m_142582_((Entity)this.targetToHeal) ? (this.waitUntilInSightTicks += 5) : --this.waitUntilInSightTicks;
        if (this.waitUntilInSightTicks == 0) {
            this.throwPotion((LivingEntity)owner);
        }
    }

    protected void stop(ServerLevel level, Villager entity, long gameTime) {
        super.m_6732_(level, (LivingEntity)entity, gameTime);
        if ((Integer)entity.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get()).orElse(null) >= (Integer)GuardConfig.COMMON.maxClericHeal.get()) {
            entity.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.LAST_THROWN_POTION.get(), (Object)level.m_46468_());
            entity.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get(), (Object)0);
        }
    }

    protected void start(ServerLevel level, Villager entity, long gameTime) {
        this.waitUntilInSightTicks = 10;
        if (!entity.m_6274_().m_21874_((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get())) {
            entity.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get(), (Object)0);
        }
    }

    public void throwPotion(LivingEntity healer) {
        healer.m_6274_().m_21879_((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get(), (Object)((Integer)healer.m_6274_().m_21952_((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get()).orElse(null) + 1));
        Potion potion = Potions.f_43587_;
        potion = this.targetToHeal.m_21223_() <= 4.0f ? Potions.f_43623_ : Potions.f_43587_;
        ThrownPotion potionentity = new ThrownPotion(healer.m_9236_(), healer);
        potionentity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
        potionentity.m_37251_((Entity)healer, healer.m_5686_(1.0f), healer.m_6080_(), -20.0f, 0.5f, 0.0f);
        healer.m_9236_().m_6263_(null, healer.m_20185_(), healer.m_20186_(), healer.m_20189_(), SoundEvents.f_12437_, healer.m_5720_(), 1.0f, 0.8f + healer.m_217043_().m_188501_() * 0.4f);
        healer.m_9236_().m_7967_((Entity)potionentity);
    }
}

