/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.GuardMemoryTypes;
import tallestegg.guardvillagers.GuardStats;
import tallestegg.guardvillagers.HandlerEvents;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.common.entities.Guard;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.loot_tables.GuardLootTables;
import tallestegg.guardvillagers.networking.GuardFollowPacket;
import tallestegg.guardvillagers.networking.GuardOpenInventoryPacket;
import tallestegg.guardvillagers.networking.GuardSetPatrolPosPacket;

@Mod(value="guardvillagers")
public class GuardVillagers {
    public static final String MODID = "guardvillagers";

    public GuardVillagers(ModContainer container, IEventBus modEventBus) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)GuardConfig.COMMON_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)GuardConfig.CLIENT_SPEC);
        container.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)GuardConfig.STARTUP_SPEC);
        modEventBus.addListener(this::setup);
        NeoForge.EVENT_BUS.register(HandlerEvents.class);
        GuardEntityType.ENTITIES.register(modEventBus);
        GuardItems.ITEMS.register(modEventBus);
        GuardSounds.SOUNDS.register(modEventBus);
        GuardLootTables.LOOT_ITEM_CONDITION_TYPES.register(modEventBus);
        GuardLootTables.LOOT_ITEM_FUNCTION_TYPES.register(modEventBus);
        GuardStats.STATS.register(modEventBus);
        GuardMemoryTypes.MEMORY_MODULE_TYPE.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::serverStart);
        modEventBus.addListener(this::addAttributes);
        modEventBus.addListener(this::addCreativeTabs);
        modEventBus.addListener(this::register);
    }

    private void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar(MODID).versioned("2.0.2");
        reg.playToServer(GuardSetPatrolPosPacket.TYPE, GuardSetPatrolPosPacket.STREAM_CODEC, GuardSetPatrolPosPacket::setPatrolPosition);
        reg.playToClient(GuardOpenInventoryPacket.TYPE, GuardOpenInventoryPacket.STREAM_CODEC, GuardOpenInventoryPacket::handle);
        reg.playToServer(GuardFollowPacket.TYPE, GuardFollowPacket.STREAM_CODEC, GuardFollowPacket::handle);
    }

    public static boolean hotvChecker(Player player, Guard guard) {
        return player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && (Boolean)GuardConfig.COMMON.giveGuardStuffHOTV.get() != false || (Boolean)GuardConfig.COMMON.giveGuardStuffHOTV.get() == false || guard.getPlayerReputation(player) > (Integer)GuardConfig.COMMON.reputationRequirement.get() && !player.level().isClientSide();
    }

    public static boolean canFollow(Player player) {
        return (Boolean)GuardConfig.COMMON.followHero.get() != false && player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) || (Boolean)GuardConfig.COMMON.followHero.get() == false;
    }

    @SubscribeEvent
    private void addCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)GuardItems.GUARD_SPAWN_EGG.get());
            event.accept((ItemLike)GuardItems.ILLUSIONER_SPAWN_EGG.get());
        }
    }

    @SubscribeEvent
    private void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    private void addAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GuardEntityType.GUARD.get(), Guard.createAttributes().build());
    }

    public static String removeModIdFromVillagerType(String stringWithModId) {
        String[] parts = stringWithModId.split(":");
        if (parts.length <= 1) {
            return parts[0];
        }
        return parts[1];
    }

    private void serverStart(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
    }

    @Mod(value="guardvillagers", dist={Dist.CLIENT})
    public static class GuardVillagersClient {
        public GuardVillagersClient(ModContainer container, IEventBus modEventBus) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }
}

