/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.common.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import tallestegg.guardvillagers.GuardMemoryTypes;
import tallestegg.guardvillagers.common.entities.Guard;
import tallestegg.guardvillagers.common.entities.ai.tasks.VillagerHelp;
import tallestegg.guardvillagers.configuration.GuardConfig;

public class HealGuardAndHero
extends VillagerHelp {
    private LivingEntity targetToHeal;
    private int waitUntilInSightTicks = 0;

    public HealGuardAndHero() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT), (List)GuardConfig.COMMON.professionsThatHeal.get());
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, Villager owner) {
        List list = (List)owner.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).get();
        if (!list.isEmpty()) {
            for (LivingEntity searchedForHeal : list) {
                if (!(searchedForHeal instanceof Guard) && !searchedForHeal.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && !(searchedForHeal instanceof Villager) || !(searchedForHeal.getHealth() < searchedForHeal.getMaxHealth()) || !((double)searchedForHeal.distanceTo((Entity)owner) <= 4.0)) continue;
                this.targetToHeal = searchedForHeal;
                return super.checkExtraStartConditions(level, owner);
            }
        }
        return false;
    }

    @Override
    protected long timeToCheck(LivingEntity owner) {
        Optional optional = owner.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.LAST_THROWN_POTION.get());
        return optional.isPresent() ? (Long)optional.get() : 0L;
    }

    protected boolean canStillUse(ServerLevel level, Villager entity, long gameTime) {
        return this.checkIfDayHavePassedFromLastActivity((LivingEntity)entity) && (Integer)entity.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get()).orElse(null) < (Integer)GuardConfig.COMMON.maxClericHeal.get();
    }

    protected void tick(ServerLevel level, Villager owner, long gameTime) {
        super.tick(level, (LivingEntity)owner, gameTime);
        BehaviorUtils.lookAtEntity((LivingEntity)owner, (LivingEntity)this.targetToHeal);
        owner.lookAt((Entity)this.targetToHeal, 30.0f, 30.0f);
        owner.getLookControl().setLookAt((Entity)this.targetToHeal);
        this.waitUntilInSightTicks = !owner.hasLineOfSight((Entity)this.targetToHeal) ? (this.waitUntilInSightTicks += 5) : --this.waitUntilInSightTicks;
        if (this.waitUntilInSightTicks == 0) {
            this.throwPotion((LivingEntity)owner);
        }
    }

    protected void stop(ServerLevel level, Villager entity, long gameTime) {
        super.stop(level, (LivingEntity)entity, gameTime);
        if ((Integer)entity.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get()).orElse(null) >= (Integer)GuardConfig.COMMON.maxClericHeal.get()) {
            entity.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.LAST_THROWN_POTION.get(), (Object)level.getDayTime());
            entity.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get(), (Object)0);
        }
    }

    protected void start(ServerLevel level, Villager entity, long gameTime) {
        this.waitUntilInSightTicks = 10;
        if (!entity.getBrain().hasMemoryValue((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get())) {
            entity.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get(), (Object)0);
        }
    }

    public void throwPotion(LivingEntity healer) {
        healer.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get(), (Object)((Integer)healer.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.TIMES_THROWN_POTION.get()).orElse(null) + 1));
        Holder potion = this.targetToHeal.getHealth() > 4.0f ? Potions.REGENERATION : Potions.HEALING;
        ThrownPotion potionentity = new ThrownPotion(healer.level(), healer);
        potionentity.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potion));
        potionentity.shootFromRotation((Entity)healer, healer.getViewXRot(1.0f), healer.getYHeadRot(), -20.0f, 0.5f, 0.0f);
        healer.level().playSound(null, healer.getX(), healer.getY(), healer.getZ(), SoundEvents.SPLASH_POTION_THROW, healer.getSoundSource(), 1.0f, 0.8f + healer.getRandom().nextFloat() * 0.4f);
        healer.level().addFreshEntity((Entity)potionentity);
    }
}

