/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.common.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import tallestegg.guardvillagers.GuardMemoryTypes;
import tallestegg.guardvillagers.common.entities.Guard;
import tallestegg.guardvillagers.common.entities.ai.tasks.VillagerHelp;
import tallestegg.guardvillagers.configuration.GuardConfig;

public class RepairGuardEquipment
extends VillagerHelp {
    private Guard guard;

    public RepairGuardEquipment() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT), (List)GuardConfig.COMMON.professionsThatRepairGuards.get());
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, Villager owner) {
        List list = (List)owner.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).get();
        if (!list.isEmpty()) {
            for (LivingEntity livingEntity : list) {
                ItemStack itemstack;
                int i;
                if (livingEntity.isInvisible() || !livingEntity.isAlive() || !(livingEntity instanceof Guard)) continue;
                Guard guard = (Guard)livingEntity;
                if (owner.getVillagerData().getProfession() == VillagerProfession.ARMORER) {
                    for (i = 0; i < guard.guardInventory.getContainerSize() - 2; ++i) {
                        itemstack = guard.guardInventory.getItem(i);
                        if (!itemstack.isDamaged() || !(itemstack.getItem() instanceof ArmorItem) || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2) continue;
                        this.guard = guard;
                        return super.checkExtraStartConditions(worldIn, owner);
                    }
                    continue;
                }
                for (i = 4; i < 6; ++i) {
                    itemstack = guard.guardInventory.getItem(i);
                    if (!itemstack.isDamaged() || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2) continue;
                    this.guard = guard;
                    return super.checkExtraStartConditions(worldIn, owner);
                }
            }
        }
        return false;
    }

    @Override
    protected long timeToCheck(LivingEntity owner) {
        Optional optional = owner.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.LAST_REPAIRED_GUARD.get());
        return optional.isPresent() ? (Long)optional.get() : 0L;
    }

    protected boolean canStillUse(ServerLevel level, Villager entity, long gameTime) {
        return (Integer)entity.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.TIMES_REPAIRED_GUARD.get()).orElse(null) < (Integer)GuardConfig.COMMON.maxVillageRepair.get();
    }

    protected void stop(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if ((Integer)entityIn.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.TIMES_REPAIRED_GUARD.get()).orElse(null) >= (Integer)GuardConfig.COMMON.maxVillageRepair.get()) {
            entityIn.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.LAST_REPAIRED_GUARD.get(), (Object)worldIn.getDayTime());
            entityIn.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            entityIn.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
            entityIn.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.TIMES_REPAIRED_GUARD.get(), (Object)0);
            float pitch = 1.0f + (this.guard.getRandom().nextFloat() - this.guard.getRandom().nextFloat()) * 0.2f;
            this.guard.playSound(SoundEvents.ANVIL_USE, 1.0f, pitch);
        }
    }

    protected void start(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (this.guard == null) {
            return;
        }
        if (!entityIn.getBrain().hasMemoryValue((MemoryModuleType)GuardMemoryTypes.TIMES_REPAIRED_GUARD.get())) {
            entityIn.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.TIMES_REPAIRED_GUARD.get(), (Object)0);
        }
    }

    protected void tick(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        this.repairGuardEquipment(entityIn);
    }

    public void repairGuardEquipment(Villager healer) {
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)healer, (Entity)this.guard, (float)0.5f, (int)0);
        if ((double)healer.distanceTo((Entity)this.guard) <= 2.0) {
            ItemStack itemstack;
            int i;
            healer.getBrain().setMemory((MemoryModuleType)GuardMemoryTypes.TIMES_REPAIRED_GUARD.get(), (Object)((Integer)healer.getBrain().getMemory((MemoryModuleType)GuardMemoryTypes.TIMES_REPAIRED_GUARD.get()).orElse(null) + 1));
            VillagerProfession profession = healer.getVillagerData().getProfession();
            if (profession == VillagerProfession.ARMORER) {
                for (i = 0; i < this.guard.guardInventory.getContainerSize() - 2; ++i) {
                    itemstack = this.guard.guardInventory.getItem(i);
                    if (!itemstack.isDamaged() || !(itemstack.getItem() instanceof ArmorItem) || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2 + this.guard.getRandom().nextInt(5)) continue;
                    itemstack.setDamageValue(itemstack.getDamageValue() - this.guard.getRandom().nextInt(5));
                }
            }
            if (profession == VillagerProfession.WEAPONSMITH) {
                for (i = 4; i < 6; ++i) {
                    itemstack = this.guard.guardInventory.getItem(i);
                    if (!itemstack.isDamaged() || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2 + this.guard.getRandom().nextInt(5)) continue;
                    itemstack.setDamageValue(itemstack.getDamageValue() - this.guard.getRandom().nextInt(5));
                }
            }
        }
    }
}

