/*
 * Decompiled with CFR 0.152.
 */
package cosmeticarmoursmod.item;

import cosmeticarmoursmod.client.model.ModelImperialCrown;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public abstract class ImperialCrownLimeItem
extends ArmorItem {
    public ImperialCrownLimeItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 10;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{2, 5, 6, 2})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 25;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("item.armor.equip_gold"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLD_INGOT)});
            }

            public String getName() {
                return "imperial_crown_lime";
            }

            public float getToughness() {
                return 0.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Helmet
    extends ImperialCrownLimeItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new ModelImperialCrown<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)ModelImperialCrown.LAYER_LOCATION)).bb_main, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.crouching = living.isShiftKeyDown();
                    armorModel.riding = defaultModel.riding;
                    armorModel.young = living.isBaby();
                    return armorModel;
                }
            });
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"\u00a76It Looks Glorious On You"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "cosmeticarmoursmod:textures/models/armor/imperialcrownlime__layer_1.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }
}

