/*
 * Decompiled with CFR 0.152.
 */
package cosmeticarmoursmod.item;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class LightGreyPlaidSkirtItem
extends ArmorItem {
    public LightGreyPlaidSkirtItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 10;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{1, 2, 3, 1})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 15;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("item.armor.equip_leather"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER)});
            }

            public String getName() {
                return "light_grey_plaid_skirt";
            }

            public float getToughness() {
                return 0.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends LightGreyPlaidSkirtItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"\u00a77"));
            list.add((Component)Component.literal((String)"\u00a77For use with Thighhigh Socks"));
            list.add((Component)Component.literal((String)"\u00a77Changable Pattern"));
            list.add((Component)Component.literal((String)"\u00a77Worn in Boots Slot"));
            list.add((Component)Component.literal((String)"\u00a77Washable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "cosmeticarmoursmod:textures/models/armor/plaidskirtlightgrey__layer_1.png";
        }
    }

    public static class Leggings
    extends LightGreyPlaidSkirtItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"\u00a77"));
            list.add((Component)Component.literal((String)"\u00a77For use with Light Grey Plaid Skirts"));
            list.add((Component)Component.literal((String)"\u00a77Changable Pattern"));
            list.add((Component)Component.literal((String)"\u00a77Worn in Leggings Slot"));
            list.add((Component)Component.literal((String)"\u00a77Washable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "cosmeticarmoursmod:textures/models/armor/plaidskirtlightgrey__layer_2.png";
        }
    }
}

