/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.beautiful_potions.mixin;

import com.cerbon.beautiful_potions.platform.Services;
import com.cerbon.beautiful_potions.potion.PotionType;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @Shadow
    @Final
    private ItemModelShaper itemModelShaper;

    @WrapOperation(method={"getModel(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemModelShaper;getItemModel(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/client/resources/model/BakedModel;")})
    private BakedModel getModel(ItemModelShaper instance, ItemStack stack, Operation<BakedModel> original) {
        if (!(stack.getItem() instanceof PotionItem)) {
            return (BakedModel)original.call(new Object[]{instance, stack});
        }
        PotionContents potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (potionContents.potion().isPresent()) {
            String variant;
            String potionId;
            String basePotionId;
            Potion potion = (Potion)((Holder)potionContents.potion().get()).value();
            ResourceLocation potionRL = BuiltInRegistries.POTION.getKey((Object)potion);
            if (potionRL == null) {
                return (BakedModel)original.call(new Object[]{instance, stack});
            }
            PotionType potionType = PotionType.get(stack);
            String potionNamespace = potionRL.getNamespace();
            String modelPath = potionNamespace + ":" + (basePotionId = this.getBasePotionId(potionId = potionRL.getPath())) + "/" + (variant = this.getPotionVariant(potionId, potionType));
            ResourceLocation modelLocation = ResourceLocation.tryParse((String)modelPath);
            if (modelLocation != null) {
                ModelManager modelManager = this.itemModelShaper.getModelManager();
                BakedModel model = Services.PLATFORM.getItemModel(modelLocation, modelManager);
                return model != null && model != modelManager.getMissingModel() ? model : (BakedModel)original.call(new Object[]{instance, stack});
            }
        }
        return (BakedModel)original.call(new Object[]{instance, stack});
    }

    @Unique
    private String getBasePotionId(String potionId) {
        if (potionId.startsWith("long_")) {
            return potionId.substring(5);
        }
        if (potionId.startsWith("strong_")) {
            return potionId.substring(7);
        }
        return potionId;
    }

    @Unique
    private String getPotionVariant(String potionId, PotionType potionType) {
        String typeString = potionType.toString().toLowerCase();
        if (potionId.startsWith("long_")) {
            return typeString + "_long";
        }
        if (potionId.startsWith("strong_")) {
            return typeString + "_strong";
        }
        return typeString.equals("normal") ? "normal" : typeString;
    }
}

