/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.action.holder;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2960;

public class ActionHolderManager {
    private final Map<IActionHolderType<?>, Map<class_2960, IAction>> actions = new HashMap();
    private final Map<IActionHolderType<?>, Map<class_2960, IActionHolder>> actionHolders = new HashMap();
    private static ActionHolderManager instance;

    private ActionHolderManager() {
    }

    public static ActionHolderManager getInstance() {
        if (instance == null) {
            instance = new ActionHolderManager();
        }
        return instance;
    }

    public void registerActionHolders(List<IActionHolder> actionHolders) {
        for (IActionHolder actionHolder : actionHolders) {
            this.actionHolders.computeIfAbsent(actionHolder.getType(), mapFunc -> new HashMap()).put(actionHolder.getLocation(), actionHolder);
            List<IAction> actionsForHolder = this.getActionsForHolder(actionHolder);
            actionHolder.clearActions();
            actionHolder.addActions(actionsForHolder);
        }
    }

    public void registerActions(List<IAction> actions) {
        for (IAction action : actions) {
            this.actions.computeIfAbsent(action.getActionHolderType(), mapFunc -> new HashMap()).put(action.getLocation(), action);
        }
        this.mapActionsByTheirHolders(actions).forEach((location, actionHolderActions) -> this.getActionHolder((class_2960)location).ifPresent(holder -> {
            holder.clearActions();
            holder.addActions((List<IAction>)actionHolderActions);
        }));
    }

    public void clearAllActionHoldersForType(IActionHolderType<?> type) {
        this.actionHolders.remove(type);
    }

    public void clearAllActions() {
        this.actions.clear();
        this.actionHolders.values().forEach(holderMap -> holderMap.values().forEach(IActionHolder::clearActions));
    }

    public List<IActionHolder> getActionHolders(List<class_2960> actionHolderLocations) {
        return actionHolderLocations.stream().map(this::getActionHolder).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Map<class_2960, List<IAction>> mapActionsByTheirHolders(List<IAction> actions) {
        return actions.stream().collect(Collectors.groupingBy(IAction::getActionHolderLocation));
    }

    private Optional<IActionHolder> getActionHolder(class_2960 location) {
        for (Map<class_2960, IActionHolder> actionHolderMap : this.actionHolders.values()) {
            if (!actionHolderMap.containsKey(location)) continue;
            return Optional.of(actionHolderMap.get(location));
        }
        return Optional.empty();
    }

    private List<IAction> getActionsForHolder(IActionHolder actionHolder) {
        return this.actions.getOrDefault(actionHolder.getType(), Collections.emptyMap()).values().stream().filter(action -> action.getActionHolderLocation().equals((Object)actionHolder.getLocation())).collect(Collectors.toList());
    }

    public Optional<IAction> getAction(class_2960 actionLocation) {
        for (Map<class_2960, IAction> actionMap : this.actions.values()) {
            if (!actionMap.containsKey(actionLocation)) continue;
            return Optional.of(actionMap.get(actionLocation));
        }
        return Optional.empty();
    }

    public List<String> getActionLocationStrings() {
        return this.actions.values().stream().flatMap(map -> map.keySet().stream()).map(class_2960::toString).collect(Collectors.toList());
    }

    public List<IAction> getActions() {
        return this.actions.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    public List<IActionHolder> getActionHolders() {
        return this.actionHolders.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }
}

