/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.item;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;

public class ItemsCondition
extends AbstractCondition {
    private final List<class_1792> items;
    private final List<class_6862<class_1792>> itemTags;

    public ItemsCondition(boolean inverted, List<class_1792> items, List<class_6862<class_1792>> itemTags) {
        super(inverted);
        this.items = items;
        this.itemTags = itemTags;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.items.stream().map(class_1792::method_63680).toArray(class_2561[]::new), this.itemTags.stream().map(class_6862::comp_327).toArray(class_2960[]::new));
    }

    @Override
    public boolean isMet(ActionData actionData) {
        class_1792 item;
        class_1799 itemStack = actionData.getData(ActionDataType.ITEM_STACK);
        if (itemStack == null && (item = actionData.getData(ActionDataType.ITEM)) != null) {
            itemStack = item.method_7854();
        }
        return itemStack != null && (this.isItem(itemStack) || this.isItemByTag(itemStack));
    }

    public IConditionType<?> getType() {
        return ConditionType.ITEMS;
    }

    private boolean isItem(class_1799 itemStack) {
        return this.items.contains(itemStack.method_7909());
    }

    private boolean isItemByTag(class_1799 itemStack) {
        return this.itemTags.stream().anyMatch(arg_0 -> ((class_1799)itemStack).method_31573(arg_0));
    }

    public List<class_1792> getItems() {
        return this.items;
    }

    public List<class_6862<class_1792>> getItemTags() {
        return this.itemTags;
    }

    public List<class_1799> getItemStacks(class_5455 registryAccess) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        for (class_1792 class_17922 : this.items) {
            itemStacks.add(new class_1799((class_1935)class_17922));
        }
        for (class_6862 class_68622 : this.itemTags) {
            registryAccess.method_30530(class_7924.field_41197).method_46733(class_68622).ifPresent(holders -> {
                for (class_6880 holder : holders) {
                    itemStacks.add(new class_1799((class_1935)holder.comp_349()));
                }
            });
        }
        return itemStacks;
    }

    public static class Serializer
    implements IConditionSerializer<ItemsCondition> {
        @Override
        public ItemsCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new ItemsCondition(inverted, this.getItems(jsonObject, "items"), this.getItemTags(jsonObject, "items"));
        }

        @Override
        public ItemsCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            int i;
            int itemCount = friendlyByteBuf.method_10816();
            int tagCount = friendlyByteBuf.method_10816();
            ArrayList<class_1792> items = new ArrayList<class_1792>();
            ArrayList<class_6862<class_1792>> itemTags = new ArrayList<class_6862<class_1792>>();
            for (i = 0; i < itemCount; ++i) {
                items.add((class_1792)class_9135.method_56365((class_5321)class_7924.field_41197).decode((Object)friendlyByteBuf));
            }
            for (i = 0; i < tagCount; ++i) {
                itemTags.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7923.field_41178.method_46765(), (class_2960)friendlyByteBuf.method_10810()));
            }
            return new ItemsCondition(inverted, items, itemTags);
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, ItemsCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_10804(type.items.size());
            friendlyByteBuf.method_10804(type.itemTags.size());
            type.items.forEach(item -> class_9135.method_56365((class_5321)class_7924.field_41197).encode((Object)friendlyByteBuf, item));
            type.itemTags.forEach(tag -> friendlyByteBuf.method_10812(tag.comp_327()));
        }
    }
}

