/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.block;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_8567;
import net.minecraft.class_9129;

public class BlockDropMultiplierReward
extends AbstractReward {
    private final int multiplier;

    public BlockDropMultiplierReward(double chance, int priority, int multiplier) {
        super(chance, priority);
        this.multiplier = multiplier;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.multiplier);
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        class_2338 blockPos;
        class_2680 blockState = actionData.getData(ActionDataType.BLOCK_STATE);
        if (blockState != null && (blockPos = actionData.getData(ActionDataType.BLOCK_POSITION)) != null) {
            class_1937 level = actionData.getData(ActionDataType.WORLD);
            if (level == null) {
                level = actionData.getPlayer().arc$getLevel();
            }
            if (level != null && level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                class_243 vec3 = class_243.method_24953((class_2382)blockPos);
                List drops = blockState.method_26189(new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)vec3).method_51874(class_181.field_1229, (Object)actionData.getPlayer().arc$getPlayer().method_6047()).method_51874(class_181.field_1224, (Object)blockState).method_51874(class_181.field_1226, (Object)actionData.getPlayer().arc$getPlayer()));
                for (class_1799 drop : drops) {
                    for (int i = 1; i < this.multiplier; ++i) {
                        level.method_8649((class_1297)new class_1542(level, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), drop));
                    }
                }
            }
        }
        return new ActionResult();
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.BLOCK_DROP_MULTIPLIER;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public static class Serializer
    implements IRewardSerializer<BlockDropMultiplierReward> {
        @Override
        public BlockDropMultiplierReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new BlockDropMultiplierReward(chance, priority, class_3518.method_15260((JsonObject)jsonObject, (String)"multiplier"));
        }

        @Override
        public BlockDropMultiplierReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new BlockDropMultiplierReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, BlockDropMultiplierReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_53002(type.multiplier);
        }
    }
}

