/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.player;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class AttackSpeedMultiplierReward
extends AbstractReward {
    private final float multiplier;

    public AttackSpeedMultiplierReward(double chance, int priority, float multiplier) {
        super(chance, priority);
        this.multiplier = multiplier;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(Float.valueOf(this.multiplier));
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        return new ActionResult().withAttackSpeedModifier(this.multiplier);
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.ATTACK_SPEED_MULTIPLIER;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public static class Serializer
    implements IRewardSerializer<AttackSpeedMultiplierReward> {
        @Override
        public AttackSpeedMultiplierReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new AttackSpeedMultiplierReward(chance, priority, class_3518.method_15259((JsonObject)jsonObject, (String)"multiplier"));
        }

        @Override
        public AttackSpeedMultiplierReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new AttackSpeedMultiplierReward(chance, priority, friendlyByteBuf.readFloat());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, AttackSpeedMultiplierReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_52941(type.multiplier);
        }
    }
}

