/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.action.type.ActionType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.data.PlayerActionHolderManager;
import com.daqem.arc.event.triggers.MovementEvents;
import com.daqem.arc.event.triggers.PlayerEvents;
import com.daqem.arc.event.triggers.StatEvents;
import com.daqem.arc.networking.ClientboundSyncPlayerActionHoldersPacket;
import com.daqem.arc.player.BlockPosCache;
import com.daqem.arc.player.stat.StatData;
import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1739;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3445;
import net.minecraft.class_3803;
import net.minecraft.class_8710;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayer
extends class_1657
implements ArcServerPlayer {
    @Shadow
    public class_3244 field_13987;
    @Unique
    private Map<class_2960, IActionHolder> arc$actionHolders = new HashMap<class_2960, IActionHolder>();
    @Unique
    private class_2371<StatData> arc$statData = class_2371.method_10211();
    @Unique
    private Map<ICondition, Integer> arc$lastDistanceInCm = new HashMap<ICondition, Integer>();
    @Unique
    private Map<ICondition, Integer> arc$lastRemainderInCm = new HashMap<ICondition, Integer>();
    @Unique
    private boolean arc$isSwimming = false;
    @Unique
    private int arc$swimmingDistanceInCm = 0;
    @Unique
    private boolean arc$isWalking = false;
    @Unique
    private float arc$walkingDistance = 0.0f;
    @Unique
    private boolean arc$isSprinting = false;
    @Unique
    private float arc$sprintingDistance = 0.0f;
    @Unique
    private boolean arc$isCrouching = false;
    @Unique
    private float arc$crouchingDistance = 0.0f;
    @Unique
    private boolean arc$isElytraFlying = false;
    @Unique
    private float arc$elytraFlyingDistance = 0.0f;
    @Unique
    private boolean arc$isGrinding = false;
    @Unique
    public boolean arc$isHorseRiding = false;
    @Unique
    public float arc$horseRidingDistance = 0.0f;
    @Unique
    public BlockPosCache arc$blockPosCache = new BlockPosCache();

    public MixinServerPlayer(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Override
    public List<IActionHolder> arc$getActionHolders() {
        return new ArrayList<IActionHolder>(this.arc$actionHolders.values());
    }

    @Override
    public void arc$addActionHolder(IActionHolder actionHolder) {
        if (actionHolder == null) {
            return;
        }
        this.arc$actionHolders.put(actionHolder.getLocation(), actionHolder);
        this.arc$syncActionHoldersWithClient();
    }

    @Override
    public void arc$addActionHolders(List<IActionHolder> actionHolders) {
        if (actionHolders == null) {
            return;
        }
        for (IActionHolder actionHolder : actionHolders) {
            this.arc$addActionHolder(actionHolder);
        }
    }

    @Override
    public void arc$removeActionHolder(IActionHolder actionHolder) {
        this.arc$actionHolders.remove(actionHolder.getLocation());
    }

    @Override
    public void arc$clearActionHolders() {
        this.arc$actionHolders.clear();
    }

    @Override
    public class_3222 arc$getServerPlayer() {
        return (class_3222)this;
    }

    @Override
    public class_2371<StatData> arc$getStatData() {
        return this.arc$statData;
    }

    @Override
    public void arc$addStatData(StatData statData) {
        this.arc$statData.add((Object)statData);
    }

    @Override
    public void arc$setSwimmingDistanceInCm(int swimmingDistanceInCm) {
        this.arc$swimmingDistanceInCm = swimmingDistanceInCm;
    }

    @Override
    public void arc$setElytraFlyingDistanceInCm(float flyingDistanceInCm) {
        this.arc$elytraFlyingDistance = flyingDistanceInCm;
    }

    @Override
    public int arc$getLastDistanceInCm(ICondition distanceCondition) {
        Integer lastDistanceInCm = this.arc$lastDistanceInCm.get(distanceCondition);
        return lastDistanceInCm == null ? 0 : lastDistanceInCm;
    }

    @Override
    public void arc$setLastDistanceInCm(ICondition distanceCondition, int lastDistanceInCm) {
        this.arc$lastDistanceInCm.put(distanceCondition, lastDistanceInCm);
    }

    @Override
    public int arc$getLastRemainderInCm(ICondition distanceCondition) {
        Integer lastRemainderInCm = this.arc$lastRemainderInCm.get(distanceCondition);
        return lastRemainderInCm == null ? 0 : lastRemainderInCm;
    }

    @Override
    public void arc$setLastRemainderInCm(ICondition distanceCondition, int lastRemainderInCm) {
        this.arc$lastRemainderInCm.put(distanceCondition, lastRemainderInCm);
    }

    @Override
    public Map<class_2960, IActionHolder> arc$getActionHoldersMap() {
        return this.arc$actionHolders;
    }

    @Override
    public Map<ICondition, Integer> arc$getLastDistancesInCm() {
        return this.arc$lastDistanceInCm;
    }

    @Override
    public Map<ICondition, Integer> arc$getLastRemaindersInCm() {
        return this.arc$lastRemainderInCm;
    }

    @Override
    public boolean arc$isSwimming() {
        return this.arc$isSwimming;
    }

    @Override
    public int arc$getSwimmingDistanceInCm() {
        return this.arc$swimmingDistanceInCm;
    }

    @Override
    public boolean arc$isWalking() {
        return this.arc$isWalking;
    }

    @Override
    public float arc$getWalkingDistance() {
        return this.arc$walkingDistance;
    }

    @Override
    public boolean arc$isSprinting() {
        return this.arc$isSprinting;
    }

    @Override
    public float arc$getSprintingDistance() {
        return this.arc$sprintingDistance;
    }

    @Override
    public boolean arc$isCrouching() {
        return this.arc$isCrouching;
    }

    @Override
    public float arc$getCrouchingDistance() {
        return this.arc$crouchingDistance;
    }

    @Override
    public boolean arc$isElytraFlying() {
        return this.arc$isElytraFlying;
    }

    @Override
    public float arc$getElytraFlyingDistance() {
        return this.arc$elytraFlyingDistance;
    }

    @Override
    public boolean arc$isGrinding() {
        return this.arc$isGrinding;
    }

    @Override
    public boolean arc$isHorseRiding() {
        return this.arc$isHorseRiding;
    }

    @Override
    public void arc$syncActionHoldersWithClient() {
        if (this.field_13987 == null) {
            return;
        }
        NetworkManager.sendToPlayer((class_3222)this.arc$getServerPlayer(), (class_8710)new ClientboundSyncPlayerActionHoldersPacket(this.arc$getActionHolders()));
    }

    @Override
    public BlockPosCache arc$getBlockPosCache() {
        return this.arc$blockPosCache;
    }

    @Override
    public double arc$nextRandomDouble() {
        return this.arc$getServerPlayer().method_59922().method_43058();
    }

    @Override
    @NotNull
    public class_1937 arc$getLevel() {
        return super.method_73183();
    }

    @Override
    public String arc$getName() {
        return super.method_5477().getString();
    }

    @Override
    public class_1657 arc$getPlayer() {
        return this.arc$getServerPlayer();
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        class_1498 horse;
        class_1297 class_12972;
        if (this.arc$isSwimming && this.method_5681()) {
            MovementEvents.onSwim(this, this.arc$swimmingDistanceInCm);
        } else if (this.arc$isSwimming) {
            this.arc$isSwimming = false;
            MovementEvents.onStopSwimming(this);
        } else if (this.method_5681()) {
            this.arc$isSwimming = true;
            MovementEvents.onStartSwimming(this);
        }
        boolean isCurrentlyWalking = this.field_5994 > this.arc$walkingDistance;
        float distance = this.field_5994 - this.arc$walkingDistance;
        if (this.arc$isWalking && isCurrentlyWalking) {
            this.arc$walkingDistance = this.field_5994;
            MovementEvents.onWalk(this, (int)(this.arc$walkingDistance * 100.0f));
        } else if (this.arc$isWalking) {
            this.arc$isWalking = false;
            MovementEvents.onStopWalking(this);
        } else if (isCurrentlyWalking) {
            this.arc$isWalking = true;
            MovementEvents.onStartWalking(this);
        }
        if (this.arc$isSprinting && this.method_5624()) {
            this.arc$sprintingDistance += distance;
            MovementEvents.onSprint(this, (int)(this.arc$sprintingDistance * 100.0f));
        } else if (this.arc$isSprinting) {
            this.arc$isSprinting = false;
            MovementEvents.onStopSprinting(this);
        } else if (this.method_5624()) {
            this.arc$isSprinting = true;
            MovementEvents.onStartSprinting(this);
        }
        if (this.arc$isHorseRiding && (class_12972 = this.method_5668()) instanceof class_1498 && (horse = (class_1498)class_12972).method_66672() && horse.method_6727()) {
            boolean isCurrentlyRiding = horse.field_5994 > this.arc$horseRidingDistance;
            float horseRidingDistance = horse.field_5994 - this.arc$horseRidingDistance;
            if (isCurrentlyRiding) {
                this.arc$horseRidingDistance += horseRidingDistance;
                MovementEvents.onHorseRide(this, (int)(this.arc$horseRidingDistance * 100.0f));
            }
        } else if (this.arc$isHorseRiding) {
            this.arc$isHorseRiding = false;
            MovementEvents.onStopHorseRiding(this);
        } else {
            class_1498 horse2;
            class_1297 class_12973 = this.method_5668();
            if (class_12973 instanceof class_1498 && (horse2 = (class_1498)class_12973).method_66672() && horse2.method_6727()) {
                this.arc$isHorseRiding = true;
                this.arc$horseRidingDistance = 0.0f;
                horse2.field_5994 = 0.0f;
                MovementEvents.onStartHorseRiding(this);
            }
        }
        if (this.arc$isCrouching && this.method_18276()) {
            this.arc$crouchingDistance += distance;
            MovementEvents.onCrouch(this, (int)(this.arc$crouchingDistance * 100.0f));
        } else if (this.arc$isCrouching) {
            this.arc$isCrouching = false;
            MovementEvents.onStopCrouching(this);
        } else if (this.method_18276()) {
            this.arc$isCrouching = true;
            MovementEvents.onStartCrouching(this);
        }
        if (this.arc$isElytraFlying && this.method_6128()) {
            MovementEvents.onElytraFly(this, (int)this.arc$elytraFlyingDistance);
        } else if (this.arc$isElytraFlying) {
            this.arc$isElytraFlying = false;
            MovementEvents.onStopElytraFlying(this);
        } else if (this.method_6128()) {
            this.arc$isElytraFlying = true;
            MovementEvents.onStartElytraFlying(this);
        }
        if (this.arc$getServerPlayer().field_7512 instanceof class_3803) {
            if (this.arc$isGrinding) {
                boolean firstSlot = false;
                boolean secondSlot = false;
                for (class_1735 slot : this.field_7512.field_7761) {
                    if (slot.method_7677().method_7909() instanceof class_1739 || slot.field_7871 instanceof class_1661) continue;
                    if (slot.method_34266() == 0) {
                        firstSlot = true;
                    }
                    if (slot.method_34266() != 1) continue;
                    secondSlot = true;
                }
                if (!firstSlot && !secondSlot) {
                    PlayerEvents.onGrindItem(this);
                }
            }
            boolean firstSlot = false;
            boolean secondSlot = false;
            for (class_1735 slot : this.field_7512.field_7761) {
                if (slot.method_7677().method_7909() instanceof class_1739 || slot.field_7871 instanceof class_1661) continue;
                if (slot.method_34266() == 0) {
                    firstSlot = true;
                }
                if (slot.method_34266() != 1) continue;
                secondSlot = true;
            }
            this.arc$isGrinding = firstSlot && secondSlot;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"awardStat(Lnet/minecraft/stats/Stat;I)V"})
    public void awardStat(class_3445<?> stat, int amount, CallbackInfo ci) {
        int previousAmount = 0;
        boolean found = false;
        for (StatData statData : this.arc$getStatData()) {
            if (!statData.getStat().equals(stat)) continue;
            previousAmount = statData.getAmount();
            statData.addAmount(amount);
            found = true;
            break;
        }
        if (!found) {
            this.arc$addStatData(new StatData(stat, amount));
        }
        StatEvents.onAwardStat(this, stat, previousAmount, previousAmount + amount);
    }

    @Inject(at={@At(value="TAIL")}, method={"onEffectAdded(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)V"})
    public void onEffectAdded(class_1293 effect, @Nullable class_1297 entity, CallbackInfo ci) {
    }

    @Inject(at={@At(value="TAIL")}, method={"onEnchantmentPerformed(Lnet/minecraft/world/item/ItemStack;I)V"})
    public void onEnchantmentPerformed(class_1799 itemStack, int level, CallbackInfo ci) {
        PlayerEvents.onEnchantItem(this, itemStack, level);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z", shift=At.Shift.BEFORE)}, method={"hurtServer"}, cancellable=true)
    public void hurt(class_3218 serverLevel, class_1282 damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        Object actionResult;
        ArcServerPlayer arcServerPlayer;
        class_1657 entity = this.arc$getPlayer();
        if (entity instanceof ArcServerPlayer) {
            arcServerPlayer = (ArcServerPlayer)entity;
            actionResult = new ActionDataBuilder(arcServerPlayer, ActionType.GET_HURT).withData(ActionDataType.DAMAGE_SOURCE, damageSource).withData(ActionDataType.DAMAGE_AMOUNT, Float.valueOf(f)).build().sendToAction();
            if (((ActionResult)actionResult).shouldCancelAction()) {
                f = 0.0f;
            }
            if (((ActionResult)actionResult).getDamageModifier() != 1.0f) {
                f *= ((ActionResult)actionResult).getDamageModifier();
            }
        }
        if ((actionResult = damageSource.method_5529()) instanceof ArcServerPlayer) {
            arcServerPlayer = (ArcServerPlayer)actionResult;
            if (((ActionResult)(actionResult = new ActionDataBuilder(arcServerPlayer, ActionType.HURT_PLAYER).withData(ActionDataType.ENTITY, entity).withData(ActionDataType.DAMAGE_AMOUNT, Float.valueOf(f)).build().sendToAction())).shouldCancelAction()) {
                f = 0.0f;
            }
            if (((ActionResult)actionResult).getDamageModifier() != 1.0f) {
                f *= ((ActionResult)actionResult).getDamageModifier();
            }
        }
        cir.setReturnValue((Object)super.method_64397(serverLevel, damageSource, f));
    }

    @Inject(at={@At(value="TAIL")}, method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"})
    public void restoreFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof ArcServerPlayer) {
            ArcServerPlayer arcServerPlayer = (ArcServerPlayer)oldPlayer;
            this.arc$actionHolders = arcServerPlayer.arc$getActionHoldersMap();
            this.arc$statData = arcServerPlayer.arc$getStatData();
            this.arc$lastDistanceInCm = arcServerPlayer.arc$getLastDistancesInCm();
            this.arc$lastRemainderInCm = arcServerPlayer.arc$getLastRemaindersInCm();
            this.arc$isSwimming = arcServerPlayer.arc$isSwimming();
            this.arc$swimmingDistanceInCm = arcServerPlayer.arc$getSwimmingDistanceInCm();
            this.arc$isWalking = arcServerPlayer.arc$isWalking();
            this.arc$walkingDistance = arcServerPlayer.arc$getWalkingDistance();
            this.arc$isSprinting = arcServerPlayer.arc$isSprinting();
            this.arc$sprintingDistance = arcServerPlayer.arc$getSprintingDistance();
            this.arc$isCrouching = arcServerPlayer.arc$isCrouching();
            this.arc$crouchingDistance = arcServerPlayer.arc$getCrouchingDistance();
            this.arc$isElytraFlying = arcServerPlayer.arc$isElytraFlying();
            this.arc$elytraFlyingDistance = arcServerPlayer.arc$getElytraFlyingDistance();
            this.arc$isGrinding = arcServerPlayer.arc$isGrinding();
            this.arc$isHorseRiding = arcServerPlayer.arc$isHorseRiding();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void readAdditionalSaveData(MinecraftServer minecraftServer, class_3218 serverLevel, GameProfile gameProfile, class_8791 clientInformation, CallbackInfo ci) {
        class_3222 class_32222 = (class_3222)this;
        if (class_32222 instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)class_32222;
            arcPlayer.arc$addActionHolders(PlayerActionHolderManager.getInstance().getPlayerActionHoldersList());
        }
    }
}

