/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc;

import com.daqem.arc.config.ArcCommonConfig;
import com.daqem.arc.data.ActionManager;
import com.daqem.arc.data.PlayerActionHolderManager;
import com.daqem.arc.event.command.EventRegisterCommands;
import com.daqem.arc.event.triggers.AdvancementEvents;
import com.daqem.arc.event.triggers.BlockEvents;
import com.daqem.arc.event.triggers.EntityEvents;
import com.daqem.arc.event.triggers.ItemEvents;
import com.daqem.arc.networking.ArcNetworking;
import com.daqem.arc.player.brewing.BrewingStandData;
import com.mojang.logging.LogUtils;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.slf4j.Logger;

public class Arc {
    public static final String MOD_ID = "arc";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<BlockPos, BrewingStandData> BREWING_STANDS = new HashMap<BlockPos, BrewingStandData>();

    public static void initCommon() {
        ArcCommonConfig.init();
        ArcNetworking.init();
        Arc.registerEvents();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new PlayerActionHolderManager());
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new ActionManager());
    }

    private static void registerEvents() {
        EventRegisterCommands.registerEvent();
        BlockEvents.registerEvents();
        ItemEvents.registerEvents();
        EntityEvents.registerEvents();
        AdvancementEvents.registerEvents();
    }

    public static ResourceLocation getId(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }

    public static MutableComponent translatable(String str) {
        return Component.translatable((String)("arc." + str));
    }

    public static MutableComponent translatable(String str, Object ... objects) {
        return Component.translatable((String)("arc." + str), (Object[])objects);
    }

    public static MutableComponent literal(String str) {
        return Component.literal((String)str);
    }

    public static boolean isDebugEnvironment() {
        return (Boolean)ArcCommonConfig.isDebug.get();
    }
}

