/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.action.holder;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.serializer.IActionHolderSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractActionHolder
implements IActionHolder {
    protected final ResourceLocation location;
    protected final Map<ResourceLocation, IAction> actions = new HashMap<ResourceLocation, IAction>();

    public AbstractActionHolder(ResourceLocation location) {
        this.location = location;
    }

    @Override
    public IActionHolderSerializer<?> getSerializer() {
        return this.getType().getSerializer();
    }

    @Override
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Override
    public List<IAction> getActions() {
        return new ArrayList<IAction>(this.actions.values());
    }

    @Override
    public void addAction(IAction action) {
        this.actions.put(action.getLocation(), action);
    }

    @Override
    public void addActions(List<IAction> actionHolderActions) {
        actionHolderActions.forEach(this::addAction);
    }

    @Override
    public void removeAction(IAction action) {
        this.actions.remove(action.getLocation());
    }

    @Override
    public void clearActions() {
        this.actions.clear();
    }
}

