/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.condition.serializer;

import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.data.serializer.ArcSerializer;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public interface IConditionSerializer<T extends ICondition>
extends ArcSerializer {
    public T fromJson(ResourceLocation var1, JsonObject var2, boolean var3);

    public T fromNetwork(ResourceLocation var1, RegistryFriendlyByteBuf var2, boolean var3);

    public static ICondition fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
        ResourceLocation resourceLocation = friendlyByteBuf.readResourceLocation();
        ResourceLocation resourceLocation2 = friendlyByteBuf.readResourceLocation();
        return ((IConditionType)ArcRegistry.CONDITION.getOptional(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Unknown condition serializer " + String.valueOf(resourceLocation)))).getSerializer().fromNetwork(resourceLocation2, friendlyByteBuf);
    }

    public static <T extends ICondition> void toNetwork(T condition, RegistryFriendlyByteBuf friendlyByteBuf, ResourceLocation location) {
        friendlyByteBuf.writeResourceLocation(ArcRegistry.CONDITION.getKey(condition.getType()));
        friendlyByteBuf.writeResourceLocation(location);
        condition.getSerializer().toNetwork(friendlyByteBuf, condition);
    }

    default public T fromJson(ResourceLocation location, JsonObject jsonObject) {
        return this.fromJson(location, jsonObject, GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"inverted", (boolean)false));
    }

    default public T fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf) {
        return this.fromNetwork(location, friendlyByteBuf, friendlyByteBuf.readBoolean());
    }

    default public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, T type) {
        friendlyByteBuf.writeBoolean(type.isInverted());
    }
}

