/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.reward;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;

public abstract class AbstractReward
implements IReward {
    private final double chance;
    private final int priority;

    public AbstractReward(double chance, int priority) {
        this.chance = chance;
        this.priority = priority;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public IRewardSerializer<? extends IReward> getSerializer() {
        return this.getType().getSerializer();
    }

    @Override
    public abstract ActionResult apply(ActionData var1);

    @Override
    public boolean passedChance(ActionData actionData) {
        return this.chance == 100.0 || actionData.getPlayer().arc$nextRandomDouble() * 100.0 <= this.chance;
    }

    @Override
    public Component getName() {
        return Arc.translatable("reward." + this.getType().getLocation().getPath());
    }

    @Override
    public Component getDescription(Object ... args) {
        return Arc.translatable("reward.description." + this.getType().getLocation().getPath(), args);
    }

    @Override
    public Component getDescription() {
        return this.getDescription(TranslatableContents.NO_ARGS);
    }

    public boolean equals(Object obj) {
        IReward reward;
        return obj instanceof IReward && (reward = (IReward)obj).getType().equals(this.getType());
    }
}

