/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.reward.type;

import com.daqem.arc.Arc;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.data.reward.CancelActionReward;
import com.daqem.arc.data.reward.block.BlockDropMultiplierReward;
import com.daqem.arc.data.reward.block.DestroySpeedMultiplierReward;
import com.daqem.arc.data.reward.effect.EffectAmplifierAdditionReward;
import com.daqem.arc.data.reward.effect.EffectDurationMultiplierReward;
import com.daqem.arc.data.reward.effect.EffectReward;
import com.daqem.arc.data.reward.effect.RemoveEffectReward;
import com.daqem.arc.data.reward.entity.DamageMultiplierReward;
import com.daqem.arc.data.reward.entity.EntityOnFireReward;
import com.daqem.arc.data.reward.entity.MultipleArrowsReward;
import com.daqem.arc.data.reward.experience.ExpMultiplierReward;
import com.daqem.arc.data.reward.experience.ExpReward;
import com.daqem.arc.data.reward.item.ItemReward;
import com.daqem.arc.data.reward.player.AttackSpeedMultiplierReward;
import com.daqem.arc.data.reward.player.MoveToEntityReward;
import com.daqem.arc.data.reward.server.CommandReward;
import com.daqem.arc.data.reward.world.DropItemReward;
import com.daqem.arc.event.events.RegistryEvent;
import com.daqem.arc.registry.ArcRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public interface RewardType<T extends IReward>
extends IRewardType<T> {
    public static final IRewardType<ExpReward> EXP = RewardType.register(Arc.getId("exp"), new ExpReward.Serializer());
    public static final IRewardType<ItemReward> ITEM = RewardType.register(Arc.getId("item"), new ItemReward.Serializer());
    public static final IRewardType<EffectReward> EFFECT = RewardType.register(Arc.getId("effect"), new EffectReward.Serializer());
    public static final IRewardType<EffectDurationMultiplierReward> EFFECT_DURATION_MULTIPLIER = RewardType.register(Arc.getId("effect_duration_multiplier"), new EffectDurationMultiplierReward.Serializer());
    public static final IRewardType<EffectAmplifierAdditionReward> EFFECT_AMPLIFIER_ADDITION = RewardType.register(Arc.getId("effect_amplifier_addition"), new EffectAmplifierAdditionReward.Serializer());
    public static final IRewardType<RemoveEffectReward> REMOVE_EFFECT = RewardType.register(Arc.getId("remove_effect"), new RemoveEffectReward.Serializer());
    public static final IRewardType<CancelActionReward> CANCEL_ACTION = RewardType.register(Arc.getId("cancel_action"), new CancelActionReward.Serializer());
    public static final IRewardType<DestroySpeedMultiplierReward> DESTROY_SPEED_MULTIPLIER = RewardType.register(Arc.getId("destroy_speed_multiplier"), new DestroySpeedMultiplierReward.Serializer());
    public static final IRewardType<AttackSpeedMultiplierReward> ATTACK_SPEED_MULTIPLIER = RewardType.register(Arc.getId("attack_speed_multiplier"), new AttackSpeedMultiplierReward.Serializer());
    public static final IRewardType<DropItemReward> DROP_ITEM = RewardType.register(Arc.getId("drop_item"), new DropItemReward.Serializer());
    public static final IRewardType<MultipleArrowsReward> MULTIPLE_ARROWS = RewardType.register(Arc.getId("multiple_arrows"), new MultipleArrowsReward.Serializer());
    public static final IRewardType<EntityOnFireReward> ENTITY_ON_FIRE = RewardType.register(Arc.getId("entity_on_fire"), new EntityOnFireReward.Serializer());
    public static final IRewardType<BlockDropMultiplierReward> BLOCK_DROP_MULTIPLIER = RewardType.register(Arc.getId("block_drop_multiplier"), new BlockDropMultiplierReward.Serializer());
    public static final IRewardType<MoveToEntityReward> MOVE_TO_ENTITY = RewardType.register(Arc.getId("move_to_entity"), new MoveToEntityReward.Serializer());
    public static final IRewardType<ExpMultiplierReward> EXP_MULTIPLIER = RewardType.register(Arc.getId("exp_multiplier"), new ExpMultiplierReward.Serializer());
    public static final IRewardType<DamageMultiplierReward> DAMAGE_MULTIPLIER = RewardType.register(Arc.getId("damage_multiplier"), new DamageMultiplierReward.Serializer());
    public static final IRewardType<CommandReward> COMMAND = RewardType.register(Arc.getId("command"), new CommandReward.Serializer());

    public static <T extends IReward> IRewardType<T> register(final ResourceLocation location, final IRewardSerializer<T> serializer) {
        return (IRewardType)Registry.register(ArcRegistry.REWARD, (ResourceLocation)location, (Object)new RewardType<T>(){

            @Override
            public ResourceLocation getLocation() {
                return location;
            }

            @Override
            public IRewardSerializer<T> getSerializer() {
                return serializer;
            }

            public String toString() {
                return location.toString();
            }
        });
    }

    public static void init() {
        ((RegistryEvent.RegisterRewardType)RegistryEvent.REGISTER_REWARD_TYPE.invoker()).registerRewardType();
    }
}

