/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.client.gui.action.components;

import com.daqem.uilib.api.client.gui.texture.INineSlicedTexture;
import com.daqem.uilib.client.gui.component.ButtonComponent;
import com.daqem.uilib.client.gui.text.TruncatedText;
import com.daqem.uilib.client.gui.texture.Textures;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ScrollItemComponent
extends ButtonComponent {
    private static final int PADDING = 4;
    private static final int TEXT_SPACING = 2;
    private static final Font FONT = Minecraft.getInstance().font;
    private static final int HEIGHT;
    private static final int WIDTH = 144;
    private final Component name;
    private final Component description;
    private final TruncatedText nameText;
    private final TruncatedText descriptionText;

    public ScrollItemComponent(Component name, Component description) {
        super((INineSlicedTexture)Textures.SCROLL_BAR_BACKGROUND, 0, 0, 144, HEIGHT);
        this.name = name;
        this.description = description;
        Objects.requireNonNull(FONT);
        this.nameText = new TruncatedText(FONT, name, 4, 4, 136, 9);
        Objects.requireNonNull(FONT);
        Objects.requireNonNull(FONT);
        this.descriptionText = new TruncatedText(FONT, description, 4, 4 + 9 + 2, 136, 9);
        this.descriptionText.setTextColor(ChatFormatting.DARK_GRAY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.nameText.renderBase(guiGraphics, mouseX, mouseY, delta);
        this.descriptionText.renderBase(guiGraphics, mouseX, mouseY, delta);
    }

    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            guiGraphics.renderTooltip(FONT, this.description, mouseX, mouseY);
        }
    }

    static {
        Objects.requireNonNull(FONT);
        HEIGHT = (9 + 4) * 2 + 2;
    }
}

