/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.client.gui.holder;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.client.gui.action.ActionScreen;
import com.daqem.uilib.api.client.gui.background.IBackground;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.api.client.gui.component.selection.ISelectionItem;
import com.daqem.uilib.client.gui.AbstractScreen;
import com.daqem.uilib.client.gui.background.Backgrounds;
import com.daqem.uilib.client.gui.component.ButtonComponent;
import com.daqem.uilib.client.gui.component.selection.SelectionListComponent;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ActionHoldersScreen
extends AbstractScreen {
    private final List<IActionHolder> actionHolders;

    public ActionHoldersScreen(List<IActionHolder> actionHolders) {
        super((Component)Arc.translatable("screen.action_holders"));
        this.actionHolders = actionHolders;
    }

    public void startScreen() {
        this.setPauseScreen(false);
        this.setBackground((IBackground)Backgrounds.getDefaultBackground((int)this.getWidth(), (int)this.getHeight()));
        SelectionListComponent selectionListComponent = new SelectionListComponent(0, 0, 166, 200, this.getFont(), this.getTitle(), this.actionHolders.stream().map(iActionHolder -> new ISelectionItem<ButtonComponent>(){

            public int getHeight() {
                return 26;
            }

            public Component getName() {
                return Arc.literal(iActionHolder.getLocation().toString());
            }

            public Component getDescription() {
                return Arc.literal("Actions: " + iActionHolder.getActions().size());
            }

            public OnClickEvent<ButtonComponent> getOnClickEvent() {
                return (clickedObject, screen, mouseX, mouseY, button) -> {
                    List<IAction> actions = ActionHolderManager.getInstance().getActions().stream().filter(iAction -> iAction.getActionHolderLocation().equals((Object)iActionHolder.getLocation())).toList();
                    Minecraft minecraft = Minecraft.getInstance();
                    if (actions.isEmpty() && minecraft.player != null) {
                        minecraft.player.sendSystemMessage((Component)Arc.translatable("message.no_actions"));
                    } else {
                        minecraft.setScreen((Screen)new ActionScreen(actions, actions.get(0)));
                    }
                    return true;
                };
            }
        }).collect(Collectors.toList()));
        selectionListComponent.center();
        this.addComponent((IComponent)selectionListComponent);
    }

    public void onTickScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
    }
}

