/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.type.IActionType;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ActionManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ActionManager() {
        super(GSON, "arc");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActions();
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (!Arc.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals("debug"));
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : map.entrySet()) {
            ResourceLocation location = entry2.getKey();
            try {
                IAction action = ActionManager.fromJson(location, GsonHelper.convertToJsonObject((JsonElement)entry2.getValue(), (String)"top element"));
                actions.add(action);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                Arc.LOGGER.error("Parsing error loading action {}", (Object)location, (Object)runtimeException);
            }
        }
        actionHolderManager.registerActions(actions);
        Arc.LOGGER.info("Loaded {} actions", (Object)actions.size());
    }

    public static IAction fromJson(ResourceLocation location, JsonObject jsonObject) {
        String type = GsonHelper.getAsString((JsonObject)jsonObject, (String)"type");
        return ((IActionType)ArcRegistry.ACTION.getOptional(ResourceLocation.parse((String)type)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported action type '" + type + "'"))).getSerializer().fromJson(location, jsonObject);
    }
}

