/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.block;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlocksCondition
extends AbstractCondition {
    private final List<Block> blocks;
    private final List<TagKey<Block>> blockTags;

    public BlocksCondition(boolean inverted, List<Block> blocks, List<TagKey<Block>> blockTags) {
        super(inverted);
        this.blocks = blocks;
        this.blockTags = blockTags;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.blocks.stream().map(Block::getName).toArray(Component[]::new), this.blockTags.stream().map(TagKey::location).toArray(ResourceLocation[]::new));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMet(ActionData actionData) {
        BlockState blockState = actionData.getData(ActionDataType.BLOCK_STATE);
        if (blockState == null) return false;
        if (this.blocks.contains(blockState.getBlock())) return true;
        if (!this.blockTags.stream().anyMatch(arg_0 -> ((BlockState)blockState).is(arg_0))) return false;
        return true;
    }

    public IConditionType<?> getType() {
        return ConditionType.BLOCKS;
    }

    public static class Serializer
    implements IConditionSerializer<BlocksCondition> {
        @Override
        public BlocksCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new BlocksCondition(inverted, this.getBlocks(jsonObject, "blocks"), this.getBlockTags(jsonObject, "blocks"));
        }

        @Override
        public BlocksCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            int i;
            int blockCount = friendlyByteBuf.readVarInt();
            int tagCount = friendlyByteBuf.readVarInt();
            ArrayList<Block> blocks = new ArrayList<Block>();
            ArrayList<TagKey<Block>> blockTags = new ArrayList<TagKey<Block>>();
            for (i = 0; i < blockCount; ++i) {
                blocks.add((Block)BuiltInRegistries.BLOCK.byId(friendlyByteBuf.readVarInt()));
            }
            for (i = 0; i < tagCount; ++i) {
                blockTags.add((TagKey<Block>)TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)friendlyByteBuf.readResourceLocation()));
            }
            return new BlocksCondition(inverted, blocks, blockTags);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, BlocksCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeVarInt(type.blocks.size());
            friendlyByteBuf.writeVarInt(type.blockTags.size());
            type.blocks.forEach(block -> friendlyByteBuf.writeVarInt(BuiltInRegistries.BLOCK.getId(block)));
            type.blockTags.forEach(tag -> friendlyByteBuf.writeResourceLocation(tag.location()));
        }
    }
}

