/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.block.properties;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BlockHardnessCondition
extends AbstractCondition {
    private final float min;
    private final float max;

    public BlockHardnessCondition(boolean inverted, float min, float max) {
        super(inverted);
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max for BlockHardnessCondition.");
        }
    }

    @Override
    public Component getDescription() {
        return this.getDescription(Float.valueOf(this.min), Float.valueOf(this.max));
    }

    @Override
    public boolean isMet(ActionData actionData) {
        BlockState blockState = actionData.getData(ActionDataType.BLOCK_STATE);
        BlockPos blockPos = actionData.getData(ActionDataType.BLOCK_POSITION);
        if (blockState == null || blockPos == null) {
            return false;
        }
        float hardness = blockState.getDestroySpeed((BlockGetter)actionData.getPlayer().arc$getLevel(), blockPos);
        return hardness >= this.min && hardness <= this.max;
    }

    public IConditionType<?> getType() {
        return ConditionType.BLOCK_HARDNESS;
    }

    public static class Serializer
    implements IConditionSerializer<BlockHardnessCondition> {
        @Override
        public BlockHardnessCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new BlockHardnessCondition(inverted, GsonHelper.getAsFloat((JsonObject)jsonObject, (String)"min", (float)Float.MIN_VALUE), GsonHelper.getAsFloat((JsonObject)jsonObject, (String)"max", (float)Float.MAX_VALUE));
        }

        @Override
        public BlockHardnessCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            return new BlockHardnessCondition(inverted, friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, BlockHardnessCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeFloat(type.min);
            friendlyByteBuf.writeFloat(type.max);
        }
    }
}

